/***************************************************************************
 *                                                                         *
   Projekt          : Jeti LiXXX & Vario Telemetry
 *                                                                         *
   Project          : Version 0.1.0
 *                                                                         *
   Datum            : 16.06.2017
 *                                                                         *
   Autor            : jopl
 *                                                                         *
   Compiler-Version : Arduino 1.8.1
 *                                                                         *
   Board            : Arduino Pro Mini 16MHz 5V
 *                                                                         *
   Notes            : This sketch uses a modified HardwareSerial library
                      taken from
                      https://github.com/Bouni/Arduino/tree/
                      ide-1.5.x-hardware-serial-9-bit
                      put into
                      ..\hardware\arduino\avr\cores\arduino
 *                                                                         *
                      PIN's used:
                      11, GND to FrSky serial port
 *                                                                         *
                      Rx,Tx & GND to Jeti Transmitter Module like this:
                                      3k3
                      Tx -------------[]------------- Jeti Signal (Signal)
                                      3k3
                      GND ------------[]------------- Jeti Signal (GND)
 *                                                                         *
 *                                                                         *
   ChangeLog        : 0.1.0 - first version
 *                                                                         *
 *                                                                         *
 ***************************************************************************/
;

#include <SoftwareSerial.h>
#include <MS5611.h>

#define PROTOCOL_HEADER       0xFE
#define PROTOCOL_TAIL         0xFF

#define CELL_ALARM_VALUE      320           // < 3.2 V => alarm
#define PROTOCOL_ALM_HEADER   0x7E
#define PROTOCOL_ALM_BYTES    0x02
#define PROTOCOL_ALM_W_ALM    0x23
#define PROTOCOL_ALM_WO_ALM   0x22

#define CELL1_PIN               A0
#define CELL1_COEF              1.36
#define CELL2_PIN               A1
#define CELL2_COEF              1.36
#define CELL3_PIN               A2
#define CELL3_COEF              1.36
#define LED_PIN                 13

boolean LEDState = false;
byte Pointer = 0;
byte pressurePointer = 5;
char IncomingChar;
char JetiBoxString[32] = {'M', '1', ' ', '-', 'X', 'X', 'X', 'm', ' ', '-', 'X', '.', 'X', 'm', '/', 's',
                          'X', '.', 'X', 'V', ' ', 'X', '.', 'X', 'V', ' ', 'X', '.', 'X', 'V', ' ', ' '
                         };
int32_t pressureSum = 0;
int32_t pressure, lastpressure, pressureResult = 0;
unsigned long time;
int galtBase, galt = 0;
boolean galtSet = false;
int vario;
float intercalc;
unsigned int U_cell_1, U_cell_2, U_cell_3;
byte AlarmByte = 0;
byte AlarmLetter = 0;
boolean Cell3Active = true;

MS5611 baro;

void setup() {
  // put your setup code here, to run once:
  Serial.begin(9600, SERIAL_9O2);         // Set up a serial line for 9-bit serial with odd parity (JetiBox)
  baro = MS5611();
  baro.begin();
  analogReference(INTERNAL);              // Internal reference 1.1 V
  pinMode(LED_PIN, OUTPUT);               // Set LED pin to output
  digitalWrite(LED_PIN, HIGH);            // Indication of function
  delay(3000);                            // 3 s delay
  if (analogRead(CELL3_PIN) < 100) {
    Cell3Active = false;
    JetiBoxString[26] = ' ';
    JetiBoxString[27] = ' ';
    JetiBoxString[28] = ' ';
    JetiBoxString[29] = ' ';
  }
  time = millis();
}

void loop() {
  // put your main code here, to run repeatedly:
  if (time < millis()) {
    time += 200;
    pressure = baro.getPressure();                  // in [0.01 mbar] = [Pa], 1300 Pa per 100 m
    pressureSum += pressure;
    pressurePointer = pressurePointer - 1;
    if (pressurePointer == 0) {
      pressurePointer = 5;
      pressureResult = pressureSum / 5;
      pressureSum = 0;
      vario = (lastpressure - pressureResult) * 77;        // * 77 (77 mm per 1 Pa) => [mm] ...
      vario = vario / 100;                          // in 0.1 m
      if (vario > 99) vario = 99;
      if (vario < -99) vario = -99;
      lastpressure = pressureResult;
      galt = pressureResult / 13;
      if (!galtSet) {
        galtBase = galt;
        galtSet = true;
      }
      galt = galtBase - galt;
    }
    Int2CharA(galt, 3);
    Int2CharV(vario, 9);
    U_cell_1 = analogRead(CELL1_PIN);
    U_cell_2 = analogRead(CELL2_PIN);
    U_cell_3 = analogRead(CELL3_PIN);
    U_cell_3 = U_cell_3 - U_cell_2;
    U_cell_2 = U_cell_2 - U_cell_1;
    U_cell_1 = U_cell_1 * CELL1_COEF;
    U_cell_2 = U_cell_2 * CELL2_COEF;
    U_cell_3 = U_cell_3 * CELL3_COEF;
    AlarmByte = 0;
    if (U_cell_1 < CELL_ALARM_VALUE) AlarmByte = AlarmByte || 0x01;
    if (U_cell_2 < CELL_ALARM_VALUE) AlarmByte = AlarmByte || 0x02;
    if (Cell3Active && (U_cell_3 < CELL_ALARM_VALUE)) AlarmByte = AlarmByte || 0x04;
    SetAlarmSign();
    Int2CharU(U_cell_1, 16);
    Int2CharU(U_cell_2, 21);
    if (Cell3Active) Int2CharU(U_cell_3, 26);
    TXJETIBOX();
    LEDState = !LEDState;
    digitalWrite(LED_PIN, LEDState);
  }
}

void TXJETIBOX() {
  if (AlarmLetter) {
    Serial.write(PROTOCOL_ALM_HEADER);
    Serial.write((PROTOCOL_ALM_BYTES + 0x100));
    Serial.write((PROTOCOL_ALM_W_ALM + 0x100));
    Serial.write((AlarmLetter + 0x100));
  }
  Serial.write(PROTOCOL_HEADER);
  Pointer = 0;
  while (Pointer < 32) {
    Serial.write((JetiBoxString[Pointer] + 0x100));
    Pointer++;
  }
  Serial.write(PROTOCOL_TAIL);
}

void Int2CharA(int i, byte x) {
  String Buffer;
  if (i < 0) JetiBoxString[x] = '-';
  else JetiBoxString[x] = ' ';
  i = abs(i);
  Buffer = String(i);
  if (Buffer.length() > 2) {
    JetiBoxString[x + 1] = Buffer[0];
    JetiBoxString[x + 2] = Buffer[1];
    JetiBoxString[x + 3] = Buffer[2];
  }
  else if ((Buffer.length() > 1)) {
    JetiBoxString[x + 1] = '0';
    JetiBoxString[x + 2] = Buffer[0];
    JetiBoxString[x + 3] = Buffer[1];
  }
  else {
    JetiBoxString[x + 1] = '0';
    JetiBoxString[x + 2] = '0';
    JetiBoxString[x + 3] = Buffer[0];
  }
}

void Int2CharV(int i, byte x) {
  String Buffer;
  if (i < 0) JetiBoxString[x] = '-';
  else JetiBoxString[x] = ' ';
  i = abs(i);
  Buffer = String(i);
  if (Buffer.length() > 1) {
    JetiBoxString[x + 1] = Buffer[0];
    JetiBoxString[x + 3] = Buffer[1];
  }
  else {
    JetiBoxString[x + 1] = '0';
    JetiBoxString[x + 3] = Buffer[0];
  }

}

void Int2CharU(int i, byte x) {
  String Buffer;
  Buffer = String(i);
  JetiBoxString[x] = Buffer[0];
  JetiBoxString[x + 2] = Buffer[1];
}

void SetAlarmSign() {
  switch (AlarmByte && B00000111) {
    case 0:
      AlarmLetter = 0;
      break;
    case 1:
      AlarmLetter = 'D';
      break;
    case 2:
      AlarmLetter = 'R';
      break;
    case 3:
      AlarmLetter = 'G';
      break;
    case 4:
      AlarmLetter = 'U';
      break;
    case 5:
      AlarmLetter = 'K';
      break;
    case 6:
      AlarmLetter = 'W';
      break;
    case 7:
      AlarmLetter = 'O';
      break;
  }
}
