/*
 * gui_strings.c
 *
 *  Created on: 27 ene. 2021
 *      Author: David
 */
#include "gui_strings.h"

// language indexes and LANGUAGE_COUNT defined in settings.h

const strings_t strings[LANGUAGE_COUNT] = {

    [lang_english] = {
      .boot_firstBoot = "First Boot!",
      .boot_Profile = "Profile",

      .main_error_noIron_Detected = "NO IRON DETECTED",
      .main_error_failsafe = "FAILSAFE MODE",
      .main_error_NTC_high = "NTC READ HIGH",
      .main_error_NTC_low = "NTC READ LOW",
      .main_error_VoltageLow = "VOLTAGE LOW",
      .main_mode_Sleep = "SLEEP",
      .main_mode_Sleep_xpos = 42,
      .main_mode_Standby = "STBY",
      .main_mode_Standby_xpos = 46,
      .main_mode_Boost = "BOOST",
      .main_mode_Boost_xpos = 41,

      .settings_IRON = "IRON",
      .settings_SYSTEM = "SYSTEM",
      .settings_DEBUG = "DEBUG",
      .settings_EDIT_TIPS = "EDIT TIPS",
      .settings_CALIBRATION = "CALIBRATION",
      .settings_EXIT = "EXIT",
#ifdef ENABLE_ADDONS
      .settings_ADDONS = "ADDONS/EXTRAS",
#endif

#ifdef ENABLE_ADDON_FUME_EXTRACTOR
      .FUME_EXTRACTOR_Title         = "FUME EXT. CTL.",
      .FUME_EXTRACTOR_Mode          = "Mode",
      .FUME_EXTRACTOR_Modes         = { "DISABLED", "AUTO", "ALW. ON" },
      .FUME_EXTRACTOR_AfterRun      = "After Run",
      .FUME_EXTRACTOR_AfterRunUnit  = "s",
#endif

#ifdef ENABLE_ADDON_SWITCH_OFF_REMINDER
      .SWITCH_OFF_REMINDER_Title               = "SW OFF REMINDER",
      .SWITCH_OFF_REMINDER_EnableDisableOption = "Reminder",
      .SWITCH_OFF_REMINDER_InactivityDelay     = "Delay",
      .SWITCH_OFF_REMINDER_ReminderPeriod     = "Period",
      .SWITCH_OFF_REMINDER_TimeUnit            = "m",
      .SWITCH_OFF_REMINDER_BeepType            = "Beep len.",
      .SWITCH_OFF_REMINDER_BeepTypes           = {"SHORT" ,"MED." ,"LONG"},
#endif

      .IRON_Profile = "Profile",
      .IRON_Max_Temp = "Max temp",
      .IRON_Min_Temp = "Min temp",
      .IRON_Standby = "Standby",
      .IRON_Sleep = "Sleep",
      .IRON_Boost = "Boost",
      .IRON_Boost_Add = " Increase",
      .IRON_Cold_Boost = "Cold Boost",
      .IRON_ColdBoost_Threshold = " Thresh.",
      .IRON_ColdBoost_Timeout = " Timeout",
      .IRON_Wake_Mode = "Wake mode",
      .IRON_Shake_Filtering = " Filter",
      .IRON_Stand_Mode = " In stand",
      .IRON_smartActiveEnable = "SMART",
      .IRON_smartActiveLoad = " LOAD",
      .IRON_Power = "Power",
      .IRON_Heater = "Heater",
      .IRON_ADC_Time = "ADC Time",
      .IRON_PWM_mul = "PWM mul.",
      .IRON_No_Iron = "No iron",
      .IRON_Error_Timeout = "Err time",
      .IRON_Error_Resume_Mode = " Resume",
      .IRON_FILTER_MENU = "FILTER MENU",
      .IRON_NTC_MENU = "NTC MENU",

      .FILTER_Filter = "Filter",
      .FILTER__Threshold = " Thresh.",
      .FILTER__Count_limit = " Count limit",
      .FILTER__Step_down = " Step down",
      .FILTER__Min = " Min",
      .FILTER_Reset_limit = "Reset limit",

      .SYSTEM_Boot = "Boot",
      .SYSTEM_Button_Wake = "Btn wake",
      .SYSTEM_Shake_Wake = "Shake wake",
      .SYSTEM_Encoder = "Encoder",
      .SYSTEM_Buzzer = "Buzzer",
      .SYSTEM_Temperature = "Temperature",
      .SYSTEM__Step = " Step",
      .SYSTEM__Big_Step = " Big step",
      .SYSTEM_Active_Detection = "Active det.",
      .SYSTEM_LVP = "LVP",
      .SYSTEM_Gui_Time = "Gui time",
      .SYSTEM_Battery = "Battery",
      .SYSTEM_DEBUG = "DEBUG",
      .SYSTEM_RESET_MENU = "RESET MENU",

      .SYSTEM_DISPLAY_MENU = "DISPLAY",
#ifndef ST756
      .DISPLAY_ContrastOrBrightness = "Brightness",
#else
      .DISPLAY_ContrastOrBrightness = "Contrast",
#endif
      .DISPLAY_StartColumn = "X",
      .DISPLAY_StartLine = "Y",
      .DISPLAY_Xflip = "X flip",
      .DISPLAY_Yflip = "Y flip",
      .DISPLAY_Ratio = "Ratio",
      .DISPLAY_Dim = "Dimmer",
      .DISPLAY_Dim_inSleep = " In sleep",
      .DISPLAY_Advanced = "ADVANCED",

      .NTC_Enable_NTC = "Enable NTC",
      .NTC_Pull = "Pull",
      .NTC__Res = " Res",
      .NTC__Beta = " Beta",
      .NTC_NTC_Detect = "NTC Detect",
      .NTC__High = " High",
      .NTC__Low = " Low",

      .RESET_Reset_Settings = "Reset Settings",
      .RESET_Reset_Profile = "Reset Profile",
      .RESET_Reset_Profiles = "Reset Profiles",
      .RESET_Reset_All = "Reset All",
      .RESET_Reset_msg_settings_1 = "RESET SYSTEM",
      .RESET_Reset_msg_settings_2 = "SETTINGS?",
      .RESET_Reset_msg_profile_1 = "RESET CURRENT",
      .RESET_Reset_msg_profile_2 = "PROFILE?",
      .RESET_Reset_msg_profiles_1 = "RESET ALL",
      .RESET_Reset_msg_profiles_2 = "PROFILES?",
      .RESET_Reset_msg_all_1 = "PERFORM FULL",
      .RESET_Reset_msg_all_2 = "SYSTEM RESET?",

      .TIP_SETTINGS_Name = "Name",
      .TIP_SETTINGS_PID_kp = "PID Kp",
      .TIP_SETTINGS_PID_ki = "PID Ki",
      .TIP_SETTINGS_PID_kd = "PID Kd",
      .TIP_SETTINGS_PID_Imax = "PID Imax",
      .TIP_SETTINGS_PID_Imin = "PID Imin",
      .TIP_SETTINGS_COPY = "COPY",
      .TIP_SETTINGS_DELETE = "DELETE",

      .CAL_ZeroSet = "Zero set   ",       // Must be 11 chars long
      .CAL_Sampling = "Sampling   ",      // Must be 11 chars long
      .CAL_Captured = "Captured   ",      // Must be 11 chars long
      .CAL_Step = "CAL STEP:",
      .CAL_Wait = "WAIT...",
      .CAL_Measured = "MEASURED:",
      .CAL_Success = "SUCCESS!",
      .CAL_Failed = "FAILED!",
      .CAL_DELTA_HIGH_1 = "DELTA TOO HIGH!",
      .CAL_DELTA_HIGH_2 = "Adjust manually",
      .CAL_DELTA_HIGH_3 = "and try again",
      .CAL_Error = "ERROR DETECTED!",
      .CAL_Aborting = "Aborting...",

      ._Language = "Language",
      .__Temp = " Temp",
      .__Delay = " Delay",
      .__Time = " Time",
      ._Cal_250 = "Cal 250\260C",
      ._Cal_400 = "Cal 400\260C",
	  ._Cal_Diff = "t2 diff.",
      ._BACK = "BACK",
      ._SAVE = "SAVE",
      ._CANCEL = "CANCEL",
      ._STOP = "STOP",
      ._RESET = "RESET",
      ._START = "START",
      ._SETTINGS = "SETTINGS",
      ._ADD_NEW = "ADD NEW",

      .ERROR_RUNAWAY = "TEMP RUNAWAY",
      .ERROR_EXCEEDED = "EXCEEDED",
      .ERROR_UNKNOWN = "UNKNOWN ERROR",
      .ERROR_SYSTEM_HALTED = "SYSTEM HALTED",
      .ERROR_BTN_RESET = "Use btn to reset",

      .OffOn =       { "OFF", "ON" },
      .DownUp =      { "DOWN", "UP" },
      .WakeModes =   { "OFF", "STBY", "SLP", "ALL" },
      .wakeMode =    { "SHAKE", "STAND" },
      .encMode =     { "REV", "FWD" },
      .InitMode =    { "SLP", "STBY", "RUN" },
      .dimMode =     { "OFF", "SLP", "ALL" },
      .errMode =     { "SLP", "RUN", "LAST" },
    },

    [lang_russian] = {
      .boot_firstBoot = "Выберите",
      .boot_Profile = "Тип",

      .main_error_noIron_Detected = "ОТСОЕДИНЕН",
      .main_error_failsafe = "РЕЖИМ ЗАЩИТЫ",
      .main_error_NTC_high = "NTC ЗНАЧ ВЫС",
      .main_error_NTC_low = "NTC ЗНАЧ НИЗ",
      .main_error_VoltageLow = "НАПР.ЗАНИЖЕНО",
      .main_mode_Sleep = "ВЫКЛ",
      .main_mode_Sleep_xpos = 46,
      .main_mode_Standby = "СОН",
      .main_mode_Standby_xpos = 49,
      .main_mode_Boost = "БУСТ",
      .main_mode_Boost_xpos = 48,

      .settings_IRON = "ПАЯЛЬНИК",
      .settings_SYSTEM = "СТАНЦИЯ",
      .settings_DEBUG = "ОТЛАДКА",
      .settings_EDIT_TIPS = "КАРТРИДЖ",
      .settings_CALIBRATION = "КАЛИБРОВКА",
      .settings_EXIT = "ВЫХОД",
#ifdef ENABLE_ADDONS
      .settings_ADDONS = "РАСШИРЕНИЯ",
#endif

#ifdef ENABLE_ADDON_FUME_EXTRACTOR
      .FUME_EXTRACTOR_Title         = "ВЫТЯЖКА",
      .FUME_EXTRACTOR_Mode          = "Режим",
      .FUME_EXTRACTOR_Modes         = { "ОТКЛ", "АВТО", "ПОСТ." },
      .FUME_EXTRACTOR_AfterRun      = "ПослеСтарта",
      .FUME_EXTRACTOR_AfterRunUnit  = "с",
#endif
#ifdef ENABLE_ADDON_SWITCH_OFF_REMINDER
      .SWITCH_OFF_REMINDER_Title               = "БУДИЛЬНИК",
      .SWITCH_OFF_REMINDER_EnableDisableOption = "Напоминать",
      .SWITCH_OFF_REMINDER_InactivityDelay     = "Задержка",
      .SWITCH_OFF_REMINDER_ReminderPeriod     = "Период",
      .SWITCH_OFF_REMINDER_TimeUnit            = "минут",
      .SWITCH_OFF_REMINDER_BeepType            = "Звонок",
      .SWITCH_OFF_REMINDER_BeepTypes           = {"КОРОТКО" ,"НОРМА" ,"ДЛИННЫЙ"},
#endif

      .IRON_Profile = "Тип",
      .IRON_Max_Temp = "Максимум",
      .IRON_Min_Temp = "Минимум",
      .IRON_Standby = "Сон через",
      .IRON_Sleep = "Выключать",
      .IRON_Boost = "Буст",
      .IRON_Boost_Add = " Догрев",
      .IRON_Cold_Boost = "Cold Boost",
      .IRON_ColdBoost_Threshold = " Thresh.",
      .IRON_ColdBoost_Timeout = " Timeout",
      .IRON_Wake_Mode = "ДатчикСна",
      .IRON_Shake_Filtering = " фильтр",
      .IRON_Stand_Mode = "Подставка",
      .IRON_smartActiveEnable = "Опр.Работы",
      .IRON_smartActiveLoad = " загрубл.",
      .IRON_Power = "Мощность",
      .IRON_Heater = "Сопр.Жала",
      .IRON_ADC_Time = "АЦП Замер",
      .IRON_PWM_mul = "ШИМ множ.",
      .IRON_No_Iron = "ПорогОткл",
      .IRON_Error_Timeout = "Вр.Ошибки",
      .IRON_Error_Resume_Mode = " Возврат к",
      .IRON_FILTER_MENU = "ФИЛЬТР ШИМ",
      .IRON_NTC_MENU = "ПАРАМ. NTC",

      .FILTER_Filter = "Фильтр ШИМ",
      .FILTER__Threshold = " Порог",
      .FILTER__Count_limit = " Отсчетов",
      .FILTER__Step_down = " Шаг вниз",
      .FILTER__Min = " Минимум",
      .FILTER_Reset_limit = "ПорогСброса",

      .SYSTEM_Boot = "Запуск с",
      .SYSTEM_Button_Wake = "Кнопка раб.",
      .SYSTEM_Shake_Wake = "Датчик раб.",
      .SYSTEM_Encoder = "Вращение",
      .SYSTEM_Buzzer = "Зуммер",
      .SYSTEM_Temperature = "Шкала темп.",
      .SYSTEM__Step = " Шаг",
      .SYSTEM__Big_Step = " Шаг быстр.",
      .SYSTEM_Active_Detection = "Проверка",
      .SYSTEM_LVP = "ПорогНапр.",
      .SYSTEM_Gui_Time = "Отрисовка",
      .SYSTEM_Battery = "Battery",
      .SYSTEM_DEBUG = "Отладка",
      .SYSTEM_RESET_MENU = "МЕНЮ СБРОСА",
      .SYSTEM_DISPLAY_MENU = "МЕНЮ ЭКРАНА",

#ifndef ST756
      .DISPLAY_ContrastOrBrightness = "Яркость",
#else
      .DISPLAY_ContrastOrBrightness = "Контраст",
#endif
      .DISPLAY_StartColumn = "X",
      .DISPLAY_StartLine = "Y",
      .DISPLAY_Xflip = "X Зерк.",
      .DISPLAY_Yflip = "Y Зерк.",
      .DISPLAY_Ratio = "Усиление",
      .DISPLAY_Dim = "Затемнять",
      .DISPLAY_Dim_inSleep = " не гасить",
      .DISPLAY_Advanced = "ADVANCED",

      .NTC_Enable_NTC = "Внешний NTC",
      .NTC_Pull = "Подтяжка",
      .NTC__Res = " Сопр-ие",
      .NTC__Beta = "  Кривая",
      .NTC_NTC_Detect = "Автоопр.",
      .NTC__High = " Макс.",
      .NTC__Low = " Мин.",

      .RESET_Reset_Settings = "Сброс Настроек",
      .RESET_Reset_Profile = "Сброс Профиля",
      .RESET_Reset_Profiles = "Сброс Профилей",
      .RESET_Reset_All = "Общий сброс",
      .RESET_Reset_msg_settings_1 = "СБРОСИТЬ",
      .RESET_Reset_msg_settings_2 = "НАСТРОЙКИ?",
      .RESET_Reset_msg_profile_1 = "СБРОСИТЬ",
      .RESET_Reset_msg_profile_2 = "ТЕКУЩИЙ?",
      .RESET_Reset_msg_profiles_1 = "СБРОСИТЬ",
      .RESET_Reset_msg_profiles_2 = "ВСЕ?",
      .RESET_Reset_msg_all_1 = "ВЕРНУТЬ К",
      .RESET_Reset_msg_all_2 = "ЗАВОДСКИМ?",

      .TIP_SETTINGS_Name = "Жало:",
      .TIP_SETTINGS_PID_kp = "ПИД kP",
      .TIP_SETTINGS_PID_ki = "ПИД kI",
      .TIP_SETTINGS_PID_kd = "ПИД kD",
      .TIP_SETTINGS_PID_Imax = "ПИД kImax",
      .TIP_SETTINGS_PID_Imin = "ПИД kIмin",
      .TIP_SETTINGS_COPY = "ДУБЛИРОВАТЬ",
      .TIP_SETTINGS_DELETE = "УДАЛИТЬ",

      .CAL_ZeroSet = "ХолСмещОУ  ",       // Must be 11 chars long
      .CAL_Sampling = "Замеряю...   ",      // Must be 11 chars long
      .CAL_Captured = "Записано   ",      // Must be 11 chars long
      .CAL_Step = "ШАГ:",
      .CAL_Wait = "ЖДИТЕ...",
      .CAL_Measured = "ЗАМЕРЯЮ:",
      .CAL_Success = "УСПЕШНО!",
      .CAL_Failed = "НЕУДАЧА!",
      .CAL_DELTA_HIGH_1 = "РАЗНИЦА >50\260C",
      .CAL_DELTA_HIGH_2 = "задайте вручную",
      .CAL_DELTA_HIGH_3 = "и повторите",
      .CAL_Error = "ОШИБКА!",
      .CAL_Aborting = "выход...",

      ._Language = "Язык",
      .__Temp = " Нагрев",
      .__Delay = " Задержка",
      .__Time = " Time",
      ._Cal_250 = "АЦП 250\260C",
      ._Cal_400 = "АЦП 400\260C",
	  ._Cal_Diff = "t2 диф.",
      ._BACK = "НАЗАД",
      ._SAVE = "СОХРАНИТЬ",
      ._CANCEL = "ОТМЕНА",
      ._STOP = "СТОП",
      ._RESET = "СБРОС",
      ._START = "НАЧАТЬ",
      ._SETTINGS = "ПАРАМЕТРЫ",
      ._ADD_NEW = "ДОБАВИТЬ",

      .ERROR_RUNAWAY = "УШЕЛ В РАЗНОС",
      .ERROR_EXCEEDED = "ПРЕВЫШЕНИЕ",
      .ERROR_UNKNOWN = "НЕИЗВ.ОШИБКА",
      .ERROR_SYSTEM_HALTED = "БЫЛИННЫЙ ОТКАЗ",
      .ERROR_BTN_RESET = "наж.для рестарта",

      .OffOn =       { "ВЫКЛ", " ВКЛ" },
      .DownUp =      { "ВНИЗ", "ВВЕРХ" },
      .WakeModes =   { "откл", "СОН", "ВЫКЛ", "все" },
      .wakeMode =    { "РУЧКА", "СТОЙКА" },
      .encMode =     { "РЕВЕРС", "ПРЯМО" },
      .InitMode =    { "ВЫКЛ", "СОН", "ПУСК" },
      .dimMode =     { "откл", "СОН", "все" },
      .errMode =     { "ВЫКЛ", "ПУСК", "ПРЕД" },
    },

    [lang_swedish] = {
      .boot_firstBoot = "Första Start!",
      .boot_Profile = "Profil",

      .main_error_noIron_Detected = "KOLV EJ UPPTÄCKT",
      .main_error_failsafe = "FELSÄKERT LÄGE",
      .main_error_NTC_high = "NTC-VÄRDE HÖGT",
      .main_error_NTC_low = "NTC-VÄRDE LÅGT",
      .main_error_VoltageLow = "SPÄNNING LÅG",
      .main_mode_Sleep = "SOVER",
      .main_mode_Sleep_xpos = 40,
      .main_mode_Standby = "STBY",
      .main_mode_Standby_xpos = 46,
      .main_mode_Boost = "BOOST",
      .main_mode_Boost_xpos = 41,

      .settings_IRON = "LÖDKOLV",
      .settings_SYSTEM = "SYSTEM",
      .settings_DEBUG = "DEBUG",
      .settings_EDIT_TIPS = "SPETSAR",
      .settings_CALIBRATION = "KALIBRERING",
      .settings_EXIT = "AVSLUTA",
#ifdef ENABLE_ADDONS
      .settings_ADDONS = "TILLÄGG/EXTRA",
#endif

#ifdef ENABLE_ADDON_FUME_EXTRACTOR
      .FUME_EXTRACTOR_Title         = "STYRN. UTSUG",
      .FUME_EXTRACTOR_Mode          = "Läge",
      .FUME_EXTRACTOR_Modes         = { "INAKTIV", "AUTO", "ALLT.PÅ" },
      .FUME_EXTRACTOR_AfterRun      = "Extratid",
      .FUME_EXTRACTOR_AfterRunUnit  = "s",
#endif

#ifdef ENABLE_ADDON_SWITCH_OFF_REMINDER
      .SWITCH_OFF_REMINDER_Title               = "AVST.PÅMINNELSE",
      .SWITCH_OFF_REMINDER_EnableDisableOption = "Påminnelse",
      .SWITCH_OFF_REMINDER_InactivityDelay     = "Fördröjning",
      .SWITCH_OFF_REMINDER_ReminderPeriod     = "Intervall",
      .SWITCH_OFF_REMINDER_TimeUnit            = "m",
      .SWITCH_OFF_REMINDER_BeepType            = "Piplängd",
      .SWITCH_OFF_REMINDER_BeepTypes           = {"KORT" ,"MED." ,"LÅNG"},
#endif

      .IRON_Profile = "Profil",
      .IRON_Max_Temp = "Max temp",
      .IRON_Min_Temp = "Min temp",
      .IRON_Standby = "Standby",
      .IRON_Sleep = "Sovläge",
      .IRON_Boost = "Boost",
      .IRON_Boost_Add = " Tillägg",
      .IRON_Cold_Boost = "Cold Boost",
      .IRON_ColdBoost_Threshold = " Thresh.",
      .IRON_ColdBoost_Timeout = " Timeout",
      .IRON_Wake_Mode = "Väckmetod",
      .IRON_Shake_Filtering = " Filter",
      .IRON_Stand_Mode = "Ställ-läge",
      .IRON_smartActiveEnable = "SmartAktiv",
      .IRON_smartActiveLoad = " Last",
      .IRON_Power = "Effekt",
      .IRON_Heater = "Element",
      .IRON_ADC_Time = "ADO Tid",
      .IRON_PWM_mul = "PWM mul.",
      .IRON_No_Iron = "Kolv ur",
      .IRON_Error_Timeout = "Feltid",
      .IRON_Error_Resume_Mode = " Återst.",
      .IRON_FILTER_MENU = "FILTER MENY",
      .IRON_NTC_MENU = "NTC MENY",

      .FILTER_Filter = "Filter",
      .FILTER__Threshold = " Tröskel",
      .FILTER__Count_limit = " Antalsgräns",
      .FILTER__Step_down = " Avbackning",
      .FILTER__Min = " Min",
      .FILTER_Reset_limit = "Resetgräns",

      .SYSTEM_Boot = "Startläge",
      .SYSTEM_Button_Wake = "Knappväck",
      .SYSTEM_Shake_Wake = "Skakväck",
      .SYSTEM_Encoder = "Encoder",
      .SYSTEM_Buzzer = "Summer",
      .SYSTEM_Temperature = "Temperatur",
      .SYSTEM__Step = " Steg",
      .SYSTEM__Big_Step = " Storsteg",
      .SYSTEM_Active_Detection = "Aktiv avk.",
      .SYSTEM_LVP = "LSS",
      .SYSTEM_Gui_Time = "Gui-tid",
      .SYSTEM_Battery = "Battery",
      .SYSTEM_DEBUG = "DEBUG",
      .SYSTEM_RESET_MENU = "ÅTERST. MENY",

      .SYSTEM_DISPLAY_MENU = "DISPLAY",
#ifndef ST756
      .DISPLAY_ContrastOrBrightness = "Ljusstyrka",
#else
      .DISPLAY_ContrastOrBrightness = "Kontrast",
#endif
      .DISPLAY_StartColumn = "X",
      .DISPLAY_StartLine = "Y",
      .DISPLAY_Xflip = "X flip",
      .DISPLAY_Yflip = "Y flip",
      .DISPLAY_Ratio = "Ratio",
      .DISPLAY_Dim = "Dimmer",
      .DISPLAY_Dim_inSleep = " I sovläge",
      .DISPLAY_Advanced = "AVANCERAT",

      .NTC_Enable_NTC = "Aktivera NTC",
      .NTC_Pull = "Pull",
      .NTC__Res = " Res",
      .NTC__Beta = " Beta",
      .NTC_NTC_Detect = "NTC Auto-avk.",
      .NTC__High = " Hög",
      .NTC__Low = " Låg",

      .RESET_Reset_Settings = "Återst. Inst.",
      .RESET_Reset_Profile = "Återst. Profil",
      .RESET_Reset_Profiles = "Återst. Profiler",
      .RESET_Reset_All = "Återst. Allt",
      .RESET_Reset_msg_settings_1 = "ÅTERST. SYSTEM-",
      .RESET_Reset_msg_settings_2 = "INSTÄLLNINGAR?",
      .RESET_Reset_msg_profile_1 = "ÅTERST. AKTUELL",
      .RESET_Reset_msg_profile_2 = "PROFIL?",
      .RESET_Reset_msg_profiles_1 = "ÅTERST. ALLA",
      .RESET_Reset_msg_profiles_2 = "PROFILER?",
      .RESET_Reset_msg_all_1 = "UTFÖR TOTAL",
      .RESET_Reset_msg_all_2 = "SYSTEMÅTERST.?",

      .TIP_SETTINGS_Name = "Namn",
      .TIP_SETTINGS_PID_kd = "PID Kd",
      .TIP_SETTINGS_PID_ki = "PID Ki",
      .TIP_SETTINGS_PID_kp = "PID Kp",
      .TIP_SETTINGS_PID_Imax = "PID Imax",
      .TIP_SETTINGS_PID_Imin = "PID Imin",
      .TIP_SETTINGS_COPY = "KOPIERA",
      .TIP_SETTINGS_DELETE = "RADERA",

      .CAL_ZeroSet = "Nolläge    ",       // Must be 11 chars long
      .CAL_Sampling = "Mäter...   ",      // Must be 11 chars long
      .CAL_Captured = "Uppmätt    ",      // Must be 11 chars long
      .CAL_Step = "KAL STEG:",
      .CAL_Wait = "VÄNTA...",
      .CAL_Measured = "UPPMÄTT:",
      .CAL_Success = "KAL.OK!",
      .CAL_Failed = "KAL.FEL!",
      .CAL_DELTA_HIGH_1 = "DELTA FÖR HÖGT!",
      .CAL_DELTA_HIGH_2 = "Justera manuellt",
      .CAL_DELTA_HIGH_3 = "och försök igen",
      .CAL_Error = "FEL UPPTÄCKT!",
      .CAL_Aborting = "Avbryter...",

      ._Language = "Språk",
      .__Temp = " Temp",
      .__Delay = " Fördr.",
      .__Time = " Time",
      ._Cal_250 = "Kal 250\260C",
      ._Cal_400 = "Kal 400\260C",
	  ._Cal_Diff = "t2 diff.",
      ._BACK = "TILLBAKA",
      ._SAVE = "SPARA",
      ._CANCEL = "AVBRYT",
      ._STOP = "STOPP",
      ._RESET = "ÅTERST.",
      ._START = "START",
      ._SETTINGS = "INSTÄLLNINGAR",
      ._ADD_NEW = "LÄGG TILL",

      .ERROR_RUNAWAY = "TEMP AVVIKELSE",
      .ERROR_EXCEEDED = "ÖVERSKRIDET",
      .ERROR_UNKNOWN = "OKÄNT FEL",
      .ERROR_SYSTEM_HALTED = "SYSTEM STOPPAT",
      .ERROR_BTN_RESET = "Anv knapp för återst.",

      .OffOn =       { "AV", "PÅ" },
      .DownUp =      { "NER", "UPP" },
      .WakeModes =   { "AV", "STBY", "SOV", "ALLA" },
      .wakeMode =    { "SKAKA", "STÄLL" },
      .encMode =     { "OMVÄND", "NORMAL" },
      .InitMode =    { "SOV", "STBY", "KÖR" },
      .dimMode =     { "AV", "SOV", "ALLA" },
      .errMode =     { "SOV", "KÖR", "FRG" },
    },

    [lang_german] = {
      .boot_firstBoot = "Erster Start",
      .boot_Profile = "Profile",

      .main_error_noIron_Detected = "KEINE LÖTSPITZE",
      .main_error_failsafe = "FAILSAFE MODUS",
      .main_error_NTC_high = "NTC WERT HOCH",
      .main_error_NTC_low = "NTC WERT NIEDRIG",
      .main_error_VoltageLow = "SPANNUNG ZU NIEDRIG",
      .main_mode_Sleep = "SLEEP",
      .main_mode_Sleep_xpos = 42,
      .main_mode_Standby = "STBY",
      .main_mode_Standby_xpos = 46,
      .main_mode_Boost = "BOOST",
      .main_mode_Boost_xpos = 41,

      .settings_IRON = "LÖTKOLBEN",
      .settings_SYSTEM = "SYSTEM",
      .settings_DEBUG = "DEBUG",
      .settings_EDIT_TIPS = "LÖTSPITZEN EDIT",
      .settings_CALIBRATION = "KALIBRIERUNG",
      .settings_EXIT = "ENDE",
#ifdef ENABLE_ADDONS
      .settings_ADDONS = "ADDONS/EXTRAS",
#endif

#ifdef ENABLE_ADDON_FUME_EXTRACTOR
      .FUME_EXTRACTOR_Title         = "FUME EXT. CTL.",
      .FUME_EXTRACTOR_Mode          = "Mode",
      .FUME_EXTRACTOR_Modes         = { "DISABLED", "AUTO", "ALW. ON" },
      .FUME_EXTRACTOR_AfterRun      = "After Run",
      .FUME_EXTRACTOR_AfterRunUnit  = "s",
#endif

#ifdef ENABLE_ADDON_SWITCH_OFF_REMINDER
      .SWITCH_OFF_REMINDER_Title               = "SW OFF REMINDER",
      .SWITCH_OFF_REMINDER_EnableDisableOption = "Reminder",
      .SWITCH_OFF_REMINDER_InactivityDelay     = "Delay",
      .SWITCH_OFF_REMINDER_ReminderPeriod     = "Period",
      .SWITCH_OFF_REMINDER_TimeUnit            = "m",
      .SWITCH_OFF_REMINDER_BeepType            = "Beep len.",
      .SWITCH_OFF_REMINDER_BeepTypes           = {"SHORT" ,"MED." ,"LONG"},
#endif

      .IRON_Profile = "Profile",
      .IRON_Max_Temp = "Max Temp",
      .IRON_Min_Temp = "Min Temp",
      .IRON_Standby = "Standby",
      .IRON_Sleep = "Sleep",
      .IRON_Boost = "Boost",
      .IRON_Boost_Add = " Erhöhen",
      .IRON_Cold_Boost = "Cold Boost",
      .IRON_ColdBoost_Threshold = " Thresh.",
      .IRON_ColdBoost_Timeout = " Timeout",
      .IRON_Wake_Mode = "Aufwachen",
      .IRON_Shake_Filtering = " Filter",
      .IRON_Stand_Mode = " Im Halter",
      .IRON_smartActiveEnable = "SMART",
      .IRON_smartActiveLoad = " LOAD",
      .IRON_Power = "Power",
      .IRON_Heater = "Heizung",
      .IRON_ADC_Time = "ADC Zeit",
      .IRON_PWM_mul = "PWM mul.",
      .IRON_No_Iron = "Kein Kolben",
      .IRON_Error_Timeout = "Err time",
      .IRON_Error_Resume_Mode = " Fortsetz.",
      .IRON_FILTER_MENU = "FILTER MENÜ",
      .IRON_NTC_MENU = "NTC MENÜ",

      .FILTER_Filter = "Filter",
      .FILTER__Threshold = " Schwelle",
      .FILTER__Count_limit = " Grenze",
      .FILTER__Step_down = " Runter",
      .FILTER__Min = " Min",
      .FILTER_Reset_limit = "Limit Reset",

      .SYSTEM_Boot = "Boot",
      .SYSTEM_Button_Wake = "Taster",
      .SYSTEM_Shake_Wake = "Bewegung",
      .SYSTEM_Encoder = "Encoder",
      .SYSTEM_Buzzer = "Buzzer",
      .SYSTEM_Temperature = "Temperatur",
      .SYSTEM__Step = " Schritt",
      .SYSTEM__Big_Step = " Sprung",
      .SYSTEM_Active_Detection = "Aktiv Erkenn.",
      .SYSTEM_LVP = "LVP",
      .SYSTEM_Gui_Time = "Gui Zeit",
      .SYSTEM_Battery = "Battery",
      .SYSTEM_DEBUG = "DEBUG",
      .SYSTEM_RESET_MENU = "RESET MENÜ",

      .SYSTEM_DISPLAY_MENU = "DISPLAY",
#ifndef ST756
      .DISPLAY_ContrastOrBrightness = "Brightness",
#else
      .DISPLAY_ContrastOrBrightness = "Kontrast",
#endif
      .DISPLAY_StartColumn = "X",
      .DISPLAY_StartLine = "Y",
      .DISPLAY_Xflip = "X flip",
      .DISPLAY_Yflip = "Y flip",
      .DISPLAY_Ratio = "Ratio",
      .DISPLAY_Dim = "Dimmer",
      .DISPLAY_Dim_inSleep = " In sleep",
      .DISPLAY_Advanced = "ADVANCED",

      .NTC_Enable_NTC = "NTC Anschalt",
      .NTC_Pull = "Pull",
      .NTC__Res = " Res",
      .NTC__Beta = " Beta",
      .NTC_NTC_Detect = "NTC Erkenn",
      .NTC__High = " Hoch",
      .NTC__Low = " Niedrig",

      .RESET_Reset_Settings = "Einstell. Reset",
      .RESET_Reset_Profile = "Profil Reset",
      .RESET_Reset_Profiles = "Profile Reset",
      .RESET_Reset_All = "Komplett Reset",
      .RESET_Reset_msg_settings_1 = "SYSTEM",
      .RESET_Reset_msg_settings_2 = "ZURÜCKSETZEN?",
      .RESET_Reset_msg_profile_1 = "AKTIVES PROFIL",
      .RESET_Reset_msg_profile_2 = "ZURÜCKSETZEN?",
      .RESET_Reset_msg_profiles_1 = "ALLE PROFILE",
      .RESET_Reset_msg_profiles_2 = "ZURÜCKSETZEN?",
      .RESET_Reset_msg_all_1 = "ALLES",
      .RESET_Reset_msg_all_2 = "ZURÜCKSETZEN?",

      .TIP_SETTINGS_Name = "Name",
      .TIP_SETTINGS_PID_kp = "PID Kp",
      .TIP_SETTINGS_PID_ki = "PID Ki",
      .TIP_SETTINGS_PID_kd = "PID Kd",
      .TIP_SETTINGS_PID_Imax = "PID Imax",
      .TIP_SETTINGS_PID_Imin = "PID Imin",
      .TIP_SETTINGS_COPY = "KOPIEREN",
      .TIP_SETTINGS_DELETE = "LÖSCHEN",

      .CAL_ZeroSet = "Zero set   ",       // Must be 11 chars long
      .CAL_Sampling = "Sampling   ",      // Must be 11 chars long
      .CAL_Captured = "Captured   ",      // Must be 11 chars long
      .CAL_Step = "CAL STEP:",
      .CAL_Wait = "WARTE...",
      .CAL_Measured = "GEMESSEN:",
      .CAL_Success = "ERFOLGREICH!",
      .CAL_Failed = "FEHLER!",
      .CAL_DELTA_HIGH_1 = "DELTA ZU HOCH!",
      .CAL_DELTA_HIGH_2 = "Manuell einstellen",
      .CAL_DELTA_HIGH_3 = "und erneut probieren",
      .CAL_Error = "FEHLER ERKANNT!",
      .CAL_Aborting = "Abbruch...",

      ._Language = "Sprache",
      .__Temp = " Temp",
      .__Delay = " Verzög.",
      .__Time = " Time",
      ._Cal_250 = "Cal 250\260C",
      ._Cal_400 = "Cal 400\260C",
	  ._Cal_Diff = "t2 diff.",
      ._BACK = "ZURÜCK",
      ._SAVE = "OK",
      ._CANCEL = "ABBRUCH",
      ._STOP = "STOP",
      ._RESET = "RESET",
      ._START = "START",
      ._SETTINGS = "EINSTELLUNGEN",
      ._ADD_NEW = "HINZUFÜGEN",

      .ERROR_RUNAWAY = "TEMP RUNAWAY",
      .ERROR_EXCEEDED = "ÜBERTROFFEN",
      .ERROR_UNKNOWN = "UNBEKANNTER FEHLER",
      .ERROR_SYSTEM_HALTED = "SYSTEM GESTOPPT",
      .ERROR_BTN_RESET = "Drücken für Reset",

      .OffOn =       { "AUS", "AN" },
      .DownUp =      { "RUNTER", "RAUF" },
      .WakeModes =   { "OFF", "STBY", "SLP", "ALL" },
      .wakeMode =    { "SHAKE", "STAND" },
      .encMode =     { "REVERSE", "NORMAL" },
      .InitMode =    { "SLP", "STBY", "RUN" },
      .dimMode =     { "OFF", "SLP", "ALL" },
      .errMode =     { "SLP", "RUN", "LAST" },
    },

    [lang_turkish] = {
      .boot_firstBoot = "İlk Önyükleme!",
      .boot_Profile = "Profil",

      .main_error_noIron_Detected = "UÇ ALGILANMADI",
      .main_error_failsafe = "GÜVENLİ MOD",
      .main_error_NTC_high = "NTC YÜKSEK OKUMA",
      .main_error_NTC_low = "NTC DÜŞÜK OKUMA",
      .main_error_VoltageLow = "VOLTAJ DÜŞÜK",
      .main_mode_Sleep = "UYKU",
      .main_mode_Sleep_xpos = 42,
      .main_mode_Standby = "BKLM",
      .main_mode_Standby_xpos = 46,
      .main_mode_Boost = "DARBE",
      .main_mode_Boost_xpos = 41,

      .settings_IRON = "ISITICI",
      .settings_SYSTEM = "SİSTEM",
      .settings_DEBUG = "HATA AYIKLAMA",
      .settings_EDIT_TIPS = "UÇ DÜZENLE",
      .settings_CALIBRATION = "KALİBRASYON",
      .settings_EXIT = "ÇIKIŞ",
#ifdef ENABLE_ADDONS
      .settings_ADDONS = "ADDONS/EXTRAS",
#endif

#ifdef ENABLE_ADDON_FUME_EXTRACTOR
      .FUME_EXTRACTOR_Title         = "FUME EXT. CTL.",
      .FUME_EXTRACTOR_Mode          = "Mode",
      .FUME_EXTRACTOR_Modes         = { "DISABLED", "AUTO", "ALW. ON" },
      .FUME_EXTRACTOR_AfterRun      = "After Run",
      .FUME_EXTRACTOR_AfterRunUnit  = "s",
#endif

#ifdef ENABLE_ADDON_SWITCH_OFF_REMINDER
      .SWITCH_OFF_REMINDER_Title               = "SW OFF REMINDER",
      .SWITCH_OFF_REMINDER_EnableDisableOption = "Reminder",
      .SWITCH_OFF_REMINDER_InactivityDelay     = "Delay",
      .SWITCH_OFF_REMINDER_ReminderPeriod     = "Period",
      .SWITCH_OFF_REMINDER_TimeUnit            = "m",
      .SWITCH_OFF_REMINDER_BeepType            = "Beep len.",
      .SWITCH_OFF_REMINDER_BeepTypes           = {"SHORT" ,"MED." ,"LONG"},
#endif

      .IRON_Profile = "Profil",
      .IRON_Max_Temp = "Max Isı",
      .IRON_Min_Temp = "Min Isı",
      .IRON_Standby = "Bekleme",
      .IRON_Sleep = "Uyku",
      .IRON_Boost = "Darbe",
      .IRON_Boost_Add = " Arttırmak",
      .IRON_Cold_Boost = "Cold Boost",
      .IRON_ColdBoost_Threshold = " Thresh.",
      .IRON_ColdBoost_Timeout = " Timeout",
      .IRON_Wake_Mode = "Uyandırma",
      .IRON_Shake_Filtering = " Filtre",
      .IRON_Stand_Mode = " Stantta",
      .IRON_smartActiveEnable = "SMART",
      .IRON_smartActiveLoad = " LOAD",
      .IRON_Power = "Güç",
      .IRON_Heater = "Isıtıcı",
      .IRON_ADC_Time = "ADC Zamanı",
      .IRON_PWM_mul = "PWM mul.",
      .IRON_No_Iron = "Uç yok",
      .IRON_Error_Timeout = "Hata zamanı",
      .IRON_Error_Resume_Mode = " Devam Et",
      .IRON_FILTER_MENU = "FİLTRE AYARLARI",
      .IRON_NTC_MENU = "NTC AYARLARI",

      .FILTER_Filter = "Filtre",
      .FILTER__Threshold = " Eşik",
      .FILTER__Count_limit = " Sayı limit",
      .FILTER__Step_down = " Düşürmek",
      .FILTER__Min = " Düşük",
      .FILTER_Reset_limit = "Sıfırlandı",

      .SYSTEM_Boot = "Başlangıç",
      .SYSTEM_Button_Wake = "Düme Uyan",
      .SYSTEM_Shake_Wake = "Salla Uyan",
      .SYSTEM_Encoder = "Potans",
      .SYSTEM_Buzzer = "Buzzer",
      .SYSTEM_Temperature = "Sıcaklık",
      .SYSTEM__Step = " Adım",
      .SYSTEM__Big_Step = " Byk Adım",
      .SYSTEM_Active_Detection = "K.Yazı",
      .SYSTEM_LVP = "DVK",
      .SYSTEM_Gui_Time = "Gui zamanı",
      .SYSTEM_Battery = "Battery",
      .SYSTEM_DEBUG = "Geliştirici",
      .SYSTEM_RESET_MENU = "MENÜ SIFIRLA",

      .SYSTEM_DISPLAY_MENU = "DISPLAY",
#ifndef ST756
      .DISPLAY_ContrastOrBrightness = "Brightness",
#else
      .DISPLAY_ContrastOrBrightness = "kontrast",
#endif
      .DISPLAY_StartColumn = "X",
      .DISPLAY_StartLine = "Y",
      .DISPLAY_Xflip = "X flip",
      .DISPLAY_Yflip = "Y flip",
      .DISPLAY_Ratio = "Ratio",
      .DISPLAY_Dim = "Karartma",
      .DISPLAY_Dim_inSleep = " Uykuda",
      .DISPLAY_Advanced = "ADVANCED",

      .NTC_Enable_NTC = "NTC Etkin",
      .NTC_Pull = "Çek",
      .NTC__Res = " Omaj",
      .NTC__Beta = " Beta",
      .NTC_NTC_Detect = "NTC Tespit",
      .NTC__High = " Yüksek",
      .NTC__Low = " Düşük",

      .RESET_Reset_Settings = "Ayarlari Sil",
      .RESET_Reset_Profile = "Profili Sil",
      .RESET_Reset_Profiles = "Profilleri Sil",
      .RESET_Reset_All = "Hepsini Sil",
      .RESET_Reset_msg_settings_1 = "SİSTEMİ SIFIRLA",
      .RESET_Reset_msg_settings_2 = "AYARLAR?",
      .RESET_Reset_msg_profile_1 = "MEVCUT SIFIRLA",
      .RESET_Reset_msg_profile_2 = "PROFİL?",
      .RESET_Reset_msg_profiles_1 = "HEPSİNİ SIFIRLA",
      .RESET_Reset_msg_profiles_2 = "PROFİLLER?",
      .RESET_Reset_msg_all_1 = "TÜMÜNÜ YAPMAK",
      .RESET_Reset_msg_all_2 = "SİSTEM SIFIRLAMA?",

      .TIP_SETTINGS_Name = "isim",
      .TIP_SETTINGS_PID_kp = "PID Kp",
      .TIP_SETTINGS_PID_ki = "PID Ki",
      .TIP_SETTINGS_PID_kd = "PID Kd",
      .TIP_SETTINGS_PID_Imax = "PID Imax",
      .TIP_SETTINGS_PID_Imin = "PID Imin",
      .TIP_SETTINGS_COPY = "KOPYALA",
      .TIP_SETTINGS_DELETE = "SİL",

      .CAL_ZeroSet = "Sıfır seti ",       // Must be 11 chars long
      .CAL_Sampling = "Örnekleme  ",      // Must be 11 chars long
      .CAL_Captured = "Yakalandı  ",      // Must be 11 chars long
      .CAL_Step = "HESAP ADIM:",
      .CAL_Wait = "BEKLE...",
      .CAL_Measured = "ÖLÇÜLEN:",
      .CAL_Success = "BAŞARILI!",
      .CAL_Failed = "ARIZALI!",
      .CAL_DELTA_HIGH_1 = "DELTA YÜKSEK!",
      .CAL_DELTA_HIGH_2 = "Manuel ayarla",
      .CAL_DELTA_HIGH_3 = "Tekrar dene",
      .CAL_Error = "HATA TESPİTİ!",
      .CAL_Aborting = "İptal...",

      ._Language = "Dil",
      .__Temp = " Isı",
      .__Delay = " Gecikme",
      .__Time = " Time",
      ._Cal_250 = "Cal 250\260C",
      ._Cal_400 = "Cal 400\260C",
	  ._Cal_Diff = "t2 fark",
      ._BACK = "GERİ",
      ._SAVE = "KAYDET",
      ._CANCEL = "ÇIK",
      ._STOP = "DURDUR",
      ._RESET = "RESET",
      ._START = "BAŞLAT",
      ._SETTINGS = "AYARLAR",
      ._ADD_NEW = "YENİ EKLE",

      .ERROR_RUNAWAY = "ISI TUTARSIZ",
      .ERROR_EXCEEDED = "AŞILDI",
      .ERROR_UNKNOWN = "BİLİNMEYEN HATA",
      .ERROR_SYSTEM_HALTED = "SİSTEM DURDU",
      .ERROR_BTN_RESET = "DÜME İLE SIFIRLA",

      .OffOn =       { "KPLI", "AÇIK" },
      .DownUp =      { "AŞAGI", "YUKARI" },
      .WakeModes =   { "KPLI", "BKLM", "UYKU", "TÜM" },
      .wakeMode =    { "SALLA", "SABİT" },
      .encMode =     { "TERS", "NORMAL" },
      .InitMode =    { "UYKU", "BKLM", "ÇLS" },
      .dimMode =     { "KPLI", "UYKU", "TÜM" },
      .errMode =     { "UYKU", "ÇLS", "SON" },
    },

      [lang_schinese] = {
        .boot_firstBoot = "首次开机！",
        .boot_Profile = "烙铁类型",

        .main_error_noIron_Detected = "未插入烙铁头",
        .main_error_failsafe = "安全模式",
        .main_error_NTC_high = "NTC 读值过高",
        .main_error_NTC_low = "NTC 读值过低",
        .main_error_VoltageLow = "电压过低",
        .main_mode_Sleep = "休眠",
        .main_mode_Sleep_xpos = 45,
        .main_mode_Standby = "睡眠",
        .main_mode_Standby_xpos = 45,
        .main_mode_Boost = "超温",
        .main_mode_Boost_xpos = 45,

        .settings_IRON = "烙铁设定",
        .settings_SYSTEM = "系统设定",
        .settings_DEBUG = "调式菜单",
        .settings_EDIT_TIPS = "编辑烙铁头",
        .settings_CALIBRATION = "温度校正",
        .settings_EXIT = "退出",
  #ifdef ENABLE_ADDONS
        .settings_ADDONS = "附加功能",
  #endif

  #ifdef ENABLE_ADDON_FUME_EXTRACTOR
        .FUME_EXTRACTOR_Title         = "排烟控制",
        .FUME_EXTRACTOR_Mode          = "模式",
        .FUME_EXTRACTOR_Modes         = { "关闭", "自动", "打开" },
        .FUME_EXTRACTOR_AfterRun      = "连续工作",
        .FUME_EXTRACTOR_AfterRunUnit  = "s",
  #endif

  #ifdef ENABLE_ADDON_SWITCH_OFF_REMINDER
        .SWITCH_OFF_REMINDER_Title                = "关机提醒",
        .SWITCH_OFF_REMINDER_EnableDisableOption  = "定时提醒",
        .SWITCH_OFF_REMINDER_InactivityDelay      = "等待延时",
        .SWITCH_OFF_REMINDER_ReminderPeriod       = "蜂鸣间隔",
        .SWITCH_OFF_REMINDER_TimeUnit             = "m",
        .SWITCH_OFF_REMINDER_BeepType             = "蜂鸣时间",
        .SWITCH_OFF_REMINDER_BeepTypes            = { "短", "中", "长" },
  #endif

        .IRON_Profile = "烙铁类型",
        .IRON_Max_Temp = "最高温度",
        .IRON_Min_Temp = "最低温度",
        .IRON_Standby = "睡眠时间",
        .IRON_Sleep = "休眠时间",
        .IRON_Boost = "超温时间",
        .IRON_Boost_Add = "└提高",
        .IRON_Cold_Boost = "冷头速热",
        .IRON_ColdBoost_Threshold = "└触发温差",
        .IRON_ColdBoost_Timeout = "└持续时长",
        .IRON_Wake_Mode = "唤醒模式",
        .IRON_Shake_Filtering = "└过滤",
        .IRON_Stand_Mode = "└进入",
        .IRON_smartActiveEnable = "智能检测",
        .IRON_smartActiveLoad = "└灵敏度",
        .IRON_Power = "功率限制",
        .IRON_Heater = "烙铁电阻",
        .IRON_ADC_Time = "ADC 周期",
        .IRON_PWM_mul = "PWM 频率",
        .IRON_No_Iron = "无烙铁阀值",
        .IRON_Error_Timeout = "错误等待",
        .IRON_Error_Resume_Mode = "└还原设置",
        .IRON_FILTER_MENU = "过滤器设置",
        .IRON_NTC_MENU = "NTC 设置",

        .FILTER_Filter = "过滤器",
        .FILTER__Threshold = "└阀值",
        .FILTER__Count_limit = "└计数限制",
        .FILTER__Step_down = "└缩小值",
        .FILTER__Min = "└最小值",
        .FILTER_Reset_limit = "重设限制",

        .SYSTEM_Boot = "开机进入",
        .SYSTEM_Button_Wake = "按钮唤醒",
        .SYSTEM_Shake_Wake = "振动唤醒",
        .SYSTEM_Encoder = "编码器",
        .SYSTEM_Buzzer = "蜂鸣器",
        .SYSTEM_Temperature = "溫度单位",
        .SYSTEM__Step = "└单格步进",
        .SYSTEM__Big_Step = "└快速步进",
        .SYSTEM_Active_Detection = "活动检测",
        .SYSTEM_LVP = "低压保护",
        .SYSTEM_Gui_Time = "显示频率",
        .SYSTEM_Battery = "系统电池",
        .SYSTEM_DEBUG = "调式菜单",
        .SYSTEM_RESET_MENU = "恢复设置",

        .SYSTEM_DISPLAY_MENU = "显示设置",
  #ifndef ST756
        .DISPLAY_ContrastOrBrightness = "亮度",
  #else
        .DISPLAY_ContrastOrBrightness = "对比度",
  #endif
        .DISPLAY_StartColumn = "Ｘ轴起点",
        .DISPLAY_StartLine = "Ｙ轴起点",
        .DISPLAY_Xflip = "上下翻转",
        .DISPLAY_Yflip = "左右翻转",
        .DISPLAY_Ratio = "比例",
        .DISPLAY_Dim = "屏幕保护",
        .DISPLAY_Dim_inSleep = "└持续显示",
        .DISPLAY_Advanced = "高级设置",

        .NTC_Enable_NTC = "外置 NTC",
        .NTC_Pull = "模式",
        .NTC__Res = "└阻值",
        .NTC__Beta = "└Ｂ值",
        .NTC_NTC_Detect = "NTC 检测",
        .NTC__High = "└高阻值",
        .NTC__Low = "└低阻值",

        .RESET_Reset_Settings = "恢复系统设置",
        .RESET_Reset_Profile = "恢复当前烙铁设置",
        .RESET_Reset_Profiles = "恢复所有烙铁设置",
        .RESET_Reset_All = "全部恢复",
        .RESET_Reset_msg_settings_1 = "确定恢复",
        .RESET_Reset_msg_settings_2 = "系统设置吗？",
        .RESET_Reset_msg_profile_1 = "确定恢复",
        .RESET_Reset_msg_profile_2 = "当前烙铁设置吗？",
        .RESET_Reset_msg_profiles_1 = "确定恢复",
        .RESET_Reset_msg_profiles_2 = "所有烙铁设置？",
        .RESET_Reset_msg_all_1 = "确定恢复",
        .RESET_Reset_msg_all_2 = "出厂设置吗？",

        .TIP_SETTINGS_Name = "名称",
        .TIP_SETTINGS_PID_kp = "PID Kp",
        .TIP_SETTINGS_PID_ki = "PID Ki",
        .TIP_SETTINGS_PID_kd = "PID Kd",
        .TIP_SETTINGS_PID_Imax = "PID Imax",
        .TIP_SETTINGS_PID_Imin = "PID Imin",
        .TIP_SETTINGS_COPY = "复制",
        .TIP_SETTINGS_DELETE = "刪除",

        .CAL_ZeroSet = "参考值     ",       // Must be 11 chars long
        .CAL_Sampling = "取样值     ",      // Must be 11 chars long
        .CAL_Captured = "设定值     ",      // Must be 11 chars long
        .CAL_Step = "校正温度：",
        .CAL_Wait = "请稍等...",
        .CAL_Measured = "测量温度：",
        .CAL_Success = "成功！",
        .CAL_Failed = "失败！",
        .CAL_DELTA_HIGH_1 = "差值过大！",
        .CAL_DELTA_HIGH_2 = "请手动调整后",
        .CAL_DELTA_HIGH_3 = "再尝试校正",
        .CAL_Error = "发生错误！",
        .CAL_Aborting = "正在退出...",

        ._Language = "系统语言",
        .__Temp = "└温度",
        .__Delay = "└延时",
        .__Time = "└时间",
        ._Cal_250 = "250\260C 校值",
        ._Cal_400 = "400\260C 校值",
		._Cal_Diff = "t2 差异。",
        ._BACK = "返回",
        ._SAVE = "保存",
        ._CANCEL = "取消",
        ._STOP = "停止",
        ._RESET = "恢复",
        ._START = "开始",
        ._SETTINGS = "设定值",
        ._ADD_NEW = "新增",

        .ERROR_RUNAWAY = "温度过高",
        .ERROR_EXCEEDED = "数值超出",
        .ERROR_UNKNOWN = "未知错误",
        .ERROR_SYSTEM_HALTED = "系统奔溃",
        .ERROR_BTN_RESET = "使用按钮复位",

        .OffOn =       { "关闭", "打开" },
        .DownUp =      { "下拉", "上拉" },
        .WakeModes =   { "关闭", "睡眠", "休眠", "全部" },
        .wakeMode =    { "振动", "支架" },
        .encMode =     { "逆时", "顺时" },
        .InitMode =    { "休眠", "睡眠", "运行" },
        .dimMode =     { "关闭", "休眠", "全部" },
        .errMode =     { "休眠", "运行", "最后" },
      },

    [lang_tchinese] = {
      .boot_firstBoot = "初次開機！",
      .boot_Profile = "烙鐵類型",

      .main_error_noIron_Detected = "未插入烙鐵頭",
      .main_error_failsafe = "安全模式",
      .main_error_NTC_high = "NTC 讀值過高",
      .main_error_NTC_low = "NTC 讀值過低",
      .main_error_VoltageLow = "電壓過低",
      .main_mode_Sleep = "休眠",
      .main_mode_Sleep_xpos = 45,
      .main_mode_Standby = "睡眠",
      .main_mode_Standby_xpos = 45,
      .main_mode_Boost = "超溫",
      .main_mode_Boost_xpos = 45,

      .settings_IRON = "烙鐵設定",
      .settings_SYSTEM = "系統設定",
      .settings_DEBUG = "偵錯資訊",
      .settings_EDIT_TIPS = "編輯烙鐵頭",
      .settings_CALIBRATION = "溫度校正",
      .settings_EXIT = "離開",
#ifdef ENABLE_ADDONS
      .settings_ADDONS = "額外功能",
#endif

#ifdef ENABLE_ADDON_FUME_EXTRACTOR
      .FUME_EXTRACTOR_Title         = "排煙控制",
      .FUME_EXTRACTOR_Mode          = "模式",
      .FUME_EXTRACTOR_Modes         = { "關閉", "自動", "開啟" },
      .FUME_EXTRACTOR_AfterRun      = "持續運作",
      .FUME_EXTRACTOR_AfterRunUnit  = "s",
#endif

#ifdef ENABLE_ADDON_SWITCH_OFF_REMINDER
      .SWITCH_OFF_REMINDER_Title                = "關機提醒",
      .SWITCH_OFF_REMINDER_EnableDisableOption  = "定時提醒",
      .SWITCH_OFF_REMINDER_InactivityDelay      = "等待延時",
      .SWITCH_OFF_REMINDER_ReminderPeriod       = "蜂鳴間隔",
      .SWITCH_OFF_REMINDER_TimeUnit             = "m",
      .SWITCH_OFF_REMINDER_BeepType             = "蜂鳴時間",
      .SWITCH_OFF_REMINDER_BeepTypes            = { "短", "中", "長" },
#endif

      .IRON_Profile = "烙鐵類型",
      .IRON_Max_Temp = "最高溫度",
      .IRON_Min_Temp = "最低溫度",
      .IRON_Standby = "睡眠時間",
      .IRON_Sleep = "休眠時間",
      .IRON_Boost = "超溫時間",
      .IRON_Boost_Add = "└提高",
      .IRON_Cold_Boost = "冷頭速熱",
      .IRON_ColdBoost_Threshold = "└觸發溫差",
      .IRON_ColdBoost_Timeout = "└持續時長",
      .IRON_Wake_Mode = "喚醒模式",
      .IRON_Shake_Filtering = "└過濾",
      .IRON_Stand_Mode = "└進入",
      .IRON_smartActiveEnable = "智慧偵測",
      .IRON_smartActiveLoad = "└靈敏度",
      .IRON_Power = "功率限制",
      .IRON_Heater = "烙鐵電阻",
      .IRON_ADC_Time = "ADC 週期",
      .IRON_PWM_mul = "PWM 頻率",
      .IRON_No_Iron = "無烙鐵閾值",
      .IRON_Error_Timeout = "錯誤等待",
      .IRON_Error_Resume_Mode = "└還原狀態",
      .IRON_FILTER_MENU = "過濾器選單",
      .IRON_NTC_MENU = "NTC 選單",

      .FILTER_Filter = "過濾值",
      .FILTER__Threshold = "└閾值",
      .FILTER__Count_limit = "└計數限制",
      .FILTER__Step_down = "└縮小值",
      .FILTER__Min = "└最小值",
      .FILTER_Reset_limit = "重設限制",

      .SYSTEM_Boot = "開機進入",
      .SYSTEM_Button_Wake = "按鈕喚醒",
      .SYSTEM_Shake_Wake = "搖晃喚醒",
      .SYSTEM_Encoder = "編碼器",
      .SYSTEM_Buzzer = "蜂鳴器",
      .SYSTEM_Temperature = "溫度單位",
      .SYSTEM__Step = "└單格步進",
      .SYSTEM__Big_Step = "└快速步進",
      .SYSTEM_Active_Detection = "活動偵測",
      .SYSTEM_LVP = "低壓保護",
      .SYSTEM_Gui_Time = "顯示頻率",
      .SYSTEM_Battery = "系統電池",
      .SYSTEM_DEBUG = "偵錯選單",
      .SYSTEM_RESET_MENU = "重設選單",

      .SYSTEM_DISPLAY_MENU = "螢幕設定",
#ifndef ST756
      .DISPLAY_ContrastOrBrightness = "亮度",
#else
      .DISPLAY_ContrastOrBrightness = "對比度",
#endif
      .DISPLAY_StartColumn = "Ｘ軸起點",
      .DISPLAY_StartLine = "Ｙ軸起點",
      .DISPLAY_Xflip = "上下翻轉",
      .DISPLAY_Yflip = "左右翻轉",
      .DISPLAY_Ratio = "比例",
      .DISPLAY_Dim = "螢幕保護",
      .DISPLAY_Dim_inSleep = "└持續顯示",
      .DISPLAY_Advanced = "進階設定",

      .NTC_Enable_NTC = "外置 NTC",
      .NTC_Pull = "模式",
      .NTC__Res = "└阻值",
      .NTC__Beta = "└Ｂ值",
      .NTC_NTC_Detect = "NTC 偵測",
      .NTC__High = "└高阻值",
      .NTC__Low = "└低阻值",

      .RESET_Reset_Settings = "重設系統設定",
      .RESET_Reset_Profile = "重設目前烙鐵設定",
      .RESET_Reset_Profiles = "重設所有烙鐵設定",
      .RESET_Reset_All = "全部重設",
      .RESET_Reset_msg_settings_1 = "確定要重設",
      .RESET_Reset_msg_settings_2 = "系統設定嗎？",
      .RESET_Reset_msg_profile_1 = "確定要重設",
      .RESET_Reset_msg_profile_2 = "目前烙鐵設定嗎？",
      .RESET_Reset_msg_profiles_1 = "確定要重設",
      .RESET_Reset_msg_profiles_2 = "所有烙鐵設定嗎？",
      .RESET_Reset_msg_all_1 = "確定要還原",
      .RESET_Reset_msg_all_2 = "出廠預設值嗎？",

      .TIP_SETTINGS_Name = "名稱",
      .TIP_SETTINGS_PID_kp = "PID Kp",
      .TIP_SETTINGS_PID_ki = "PID Ki",
      .TIP_SETTINGS_PID_kd = "PID Kd",
      .TIP_SETTINGS_PID_Imax = "PID Imax",
      .TIP_SETTINGS_PID_Imin = "PID Imin",
      .TIP_SETTINGS_COPY = "複製",
      .TIP_SETTINGS_DELETE = "刪除",

      .CAL_ZeroSet = "參照值     ",       // Must be 11 chars long
      .CAL_Sampling = "取樣值     ",      // Must be 11 chars long
      .CAL_Captured = "設定值     ",      // Must be 11 chars long
      .CAL_Step = "校正溫度：",
      .CAL_Wait = "請稍等...",
      .CAL_Measured = "測量溫度：",
      .CAL_Success = "成功！",
      .CAL_Failed = "失敗！",
      .CAL_DELTA_HIGH_1 = "差值過大！",
      .CAL_DELTA_HIGH_2 = "請手動調整後",
      .CAL_DELTA_HIGH_3 = "再嘗試校正",
      .CAL_Error = "發生錯誤！",
      .CAL_Aborting = "正在退出...",

      ._Language = "系統語言",
      .__Temp = "└溫度",
      .__Delay = "└延時",
      .__Time = "└時間",
      ._Cal_250 = "250\260C 校值",
      ._Cal_400 = "400\260C 校值",
	  ._Cal_Diff = "t2 差異。",
      ._BACK = "返回",
      ._SAVE = "儲存",
      ._CANCEL = "取消",
      ._STOP = "停止",
      ._RESET = "重設",
      ._START = "開始",
      ._SETTINGS = "設定值",
      ._ADD_NEW = "新增",

      .ERROR_RUNAWAY = "溫度過高",
      .ERROR_EXCEEDED = "數值超出",
      .ERROR_UNKNOWN = "未知錯誤",
      .ERROR_SYSTEM_HALTED = "系統當機",
      .ERROR_BTN_RESET = "使用按鈕來重設",

      .OffOn =       { "關閉", "開啟" },
      .DownUp =      { "下拉", "上拉" },
      .WakeModes =   { "關閉", "睡眠", "休眠", "全部" },
      .wakeMode =    { "搖晃", "支架" },
      .encMode =     { "逆時", "順時" },
      .InitMode =    { "休眠", "睡眠", "運作" },
      .dimMode =     { "關閉", "休眠", "全部" },
      .errMode =     { "休眠", "運作", "最後" },
    },

    [lang_bulgarian] = {
      .boot_firstBoot = "Първи старт!",
      .boot_Profile = "Профил",

      .main_error_noIron_Detected = "НЯМА ВРЪХ",
      .main_error_failsafe = "БЕЗОПАСЕН РЕЖИМ",
      .main_error_NTC_high = "NTC Е ВИСОКО",
      .main_error_NTC_low = "NTC Е НИСКО",
      .main_error_VoltageLow = "НИСКО НАПРЖЕНИЕ",
      .main_mode_Sleep = "СЪН",
      .main_mode_Sleep_xpos = 42,
      .main_mode_Standby = "ГТВНСТ",
      .main_mode_Standby_xpos = 46,
      .main_mode_Boost = "ПОДСИЛВАНЕ",
      .main_mode_Boost_xpos = 41,

      .settings_IRON = "ПОЯЛНИК",
      .settings_SYSTEM = "СТАНЦИЯ",
      .settings_DEBUG = "ГРЕШКИ",
      .settings_EDIT_TIPS = "ВЪРХОВЕ",
      .settings_CALIBRATION = "КАЛИБРИРАНЕ",
      .settings_EXIT = "ИЗХОД",
#ifdef ENABLE_ADDONS
      .settings_ADDONS = "Добавки",
#endif

#ifdef ENABLE_ADDON_FUME_EXTRACTOR
      .FUME_EXTRACTOR_Title         = "FUME EXT. CTL.",
      .FUME_EXTRACTOR_Mode          = "Режим",
      .FUME_EXTRACTOR_Modes         = { "DISABLED", "AUTO", "ALW. ON" },
      .FUME_EXTRACTOR_AfterRun      = "After Run",
      .FUME_EXTRACTOR_AfterRunUnit  = "с",
#endif

#ifdef ENABLE_ADDON_SWITCH_OFF_REMINDER
      .SWITCH_OFF_REMINDER_Title               = "SW OFF REMINDER",
      .SWITCH_OFF_REMINDER_EnableDisableOption = "Напомняне",
      .SWITCH_OFF_REMINDER_InactivityDelay     = "Закъснение",
      .SWITCH_OFF_REMINDER_ReminderPeriod      = "Период",
      .SWITCH_OFF_REMINDER_TimeUnit            = "мин.",
      .SWITCH_OFF_REMINDER_BeepType            = "Звук",
      .SWITCH_OFF_REMINDER_BeepTypes           = {"КЪС" ,"СРЕДЕН" ,"ДЪЛЪГ"},
#endif

      .IRON_Profile = "Профил",
      .IRON_Max_Temp = "t\260макс",
      .IRON_Min_Temp = "t\260мин",
      .IRON_Standby = "Готовност",
      .IRON_Sleep = "Заспиване",
      .IRON_Boost = "Подсилване",
      .IRON_Boost_Add = " Увелич.",
      .IRON_Cold_Boost = "Cold Boost",
      .IRON_ColdBoost_Threshold = " Thresh.",
      .IRON_ColdBoost_Timeout = " Timeout",
      .IRON_Wake_Mode = "Събуждане",
      .IRON_Shake_Filtering = " Филтър",
      .IRON_Stand_Mode = " Поставка",
      .IRON_smartActiveEnable = "Интел.вкл",
      .IRON_smartActiveLoad = " Товар",
      .IRON_Power = "Мощност",
      .IRON_Heater = "Нагревател",
      .IRON_ADC_Time = "Време АЦП",
      .IRON_PWM_mul = "Множ. шим",
      .IRON_No_Iron = "Без поял.",
      .IRON_Error_Timeout = "Врм. гршк",
      .IRON_Error_Resume_Mode = " Възстан.",
      .IRON_FILTER_MENU = "ФИЛТЪР",
      .IRON_NTC_MENU = "NTC",

      .FILTER_Filter = "Филтър",
      .FILTER__Threshold = " Праг",
      .FILTER__Count_limit = " Огранич.брой",
      .FILTER__Step_down = " Step down",
      .FILTER__Min = " Мин.",
      .FILTER_Reset_limit = "Нулир.огрнч.",

      .SYSTEM_Boot = "Старт",
      .SYSTEM_Button_Wake = "Сбжд.бут.",
      .SYSTEM_Shake_Wake =  "Сбжд.двж.",
      .SYSTEM_Encoder = "Въртене",
      .SYSTEM_Buzzer = "Зумер",
      .SYSTEM_Temperature = "Температура",
      .SYSTEM__Step = " Стъпка1",
      .SYSTEM__Big_Step = " Стъпка2",
      .SYSTEM_Active_Detection = "Проверка",
      .SYSTEM_LVP = "Нис.напрж",
      .SYSTEM_Gui_Time = "Опресняв.",
      .SYSTEM_Battery = "Battery",
      .SYSTEM_DEBUG = "ГРЕШКИ",
      .SYSTEM_RESET_MENU = "НУЛИРАНЕ",

      .SYSTEM_DISPLAY_MENU = "ЕКРАН",
#ifndef ST756
      .DISPLAY_ContrastOrBrightness = "Яркост",
#else
      .DISPLAY_ContrastOrBrightness = "Контраст",
#endif
      .DISPLAY_StartColumn = "X",
      .DISPLAY_StartLine = "Y",
      .DISPLAY_Xflip = "Обръщ. X",
      .DISPLAY_Yflip = "Обръщ. Y",
      .DISPLAY_Ratio = "Съотношение",
      .DISPLAY_Dim = "Затъмяване",
      .DISPLAY_Dim_inSleep = " При сън",
      .DISPLAY_Advanced = "РАЗШИРЕНИ",

      .NTC_Enable_NTC = "NTC",
      .NTC_Pull = "Pull",
      .NTC__Res = " Съпротив.",
      .NTC__Beta = " Бета",
      .NTC_NTC_Detect = "NTC Detect",
      .NTC__High = " Високо",
      .NTC__Low = " Ниско",

      .RESET_Reset_Settings = "Настройки",
      .RESET_Reset_Profile = "Профил",
      .RESET_Reset_Profiles = "Профили",
      .RESET_Reset_All = "Всичко",
      .RESET_Reset_msg_settings_1 = "НУЛИРАНЕ НА",
      .RESET_Reset_msg_settings_2 = "НАСТРОЙКИТЕ?",
      .RESET_Reset_msg_profile_1 =  "НУЛИРАНЕ ТЕКУЩИЯ",
      .RESET_Reset_msg_profile_2 = "ПРОФИЛ?",
      .RESET_Reset_msg_profiles_1 = "НУЛИРАНЕ ВСИЧКИ",
      .RESET_Reset_msg_profiles_2 = "ПРОФИЛИ?",
      .RESET_Reset_msg_all_1 = "ЗАВОДСКИ",
      .RESET_Reset_msg_all_2 = "НАСТРОЙКИ?",

      .TIP_SETTINGS_Name = "Име",
      .TIP_SETTINGS_PID_kp = "PID Kп",
      .TIP_SETTINGS_PID_ki = "PID Kи",
      .TIP_SETTINGS_PID_kd = "PID Kд",
      .TIP_SETTINGS_PID_Imax = "PID Iмакс",
      .TIP_SETTINGS_PID_Imin = "PID Iмин",
      .TIP_SETTINGS_COPY = "КОПИРАНЕ",
      .TIP_SETTINGS_DELETE = "ПРЕМАХВАНЕ",

      .CAL_ZeroSet = "Нулева t\260  ",    // Must be 11 chars long
      .CAL_Sampling = "Взема проба",      // Must be 11 chars long
      .CAL_Captured = "Проба взета",      // Must be 11 chars long
      .CAL_Step = "СТЪПКА:",
      .CAL_Wait = "WAIT...",
      .CAL_Measured = "ИЗМЕРЕНО:",
      .CAL_Success = "ГОТОВО!",
      .CAL_Failed = "ГРЕШКА!",
      .CAL_DELTA_HIGH_1 = "ГОЛЯМА РАЗЛИКА!",
      .CAL_DELTA_HIGH_2 = "Настройте ръчно и",
      .CAL_DELTA_HIGH_3 = "пробвайте отново",
      .CAL_Error = "ОТКРИТА ГРЕШКА!",
      .CAL_Aborting = "Прекъсване...",

      ._Language = "Език",
      .__Temp = " t\260",
      .__Delay = " Забавяне",
      .__Time = " Time",
      ._Cal_250 = "Кал. 250\260C",
      ._Cal_400 = "Кал. 400\260C",
	  ._Cal_Diff = "t2 диф.",
      ._BACK = "НАЗАД",
      ._SAVE = "ЗАПАЗВАНЕ",
      ._CANCEL = "ОТКАЗ",
      ._STOP = "СПИРАНЕ",
      ._RESET = "НУЛИРАНЕ",
      ._START = "НАЧАЛО",
      ._SETTINGS = "НАСТРОЙКИ",
      ._ADD_NEW = "ДОБАВЯНЕ",

      .ERROR_RUNAWAY = "ПРЕВИШ. ТЕМП.",
      .ERROR_EXCEEDED = "ПРЕВИШЕНА",
      .ERROR_UNKNOWN = "НЕЯСНА ГРЕШКА",
      .ERROR_SYSTEM_HALTED = "СИСТЕМА ИЗКЛЮЧ.",
      .ERROR_BTN_RESET = "Натиск. за нулир.",

      .OffOn =       { "ИЗКЛ", "ВКЛ" },
      .DownUp =      { "ГОРЕ", "ДОЛУ" },
      .WakeModes =   { "ИЗКЛ", "ГТВНСТ", "СЪН", "ВСИЧКИ" },
      .wakeMode =    { "ВЗЕМ.", "ОСТА." },
      .encMode =     { "НАЗАД", "НАПРЕД" },
      .InitMode =    { "СЪН", "ГТВНСТ", "РАБОТИ" },
      .dimMode =     { "ИЗКЛ", "СЪН", "ВСИЧКИ" },
      .errMode =     { "СЪН", "РАБОТИ", "ПРЕДНО" },
    },
    [lang_czech] = {
      .boot_firstBoot = "První zapnutí!",
      .boot_Profile = "Profil",

      .main_error_noIron_Detected = "HROT NEZJIŠTĚN",
      .main_error_failsafe = "ZÁCHRANNÝ MÓD",
      .main_error_NTC_high = "NTC TEPLOTA VYSOKÁ",
      .main_error_NTC_low = "NTC TEPLOTA NÍZKÁ",
      .main_error_VoltageLow = "NAPĚTÍ JE NÍZKÉ",
      .main_mode_Sleep = "SPÁNEK",
      .main_mode_Sleep_xpos = 37,
      .main_mode_Standby = "ÚTLUM",
      .main_mode_Standby_xpos = 42,
      .main_mode_Boost = "TURBO",
      .main_mode_Boost_xpos = 41,

      .settings_IRON = "PROFIL ",
      .settings_SYSTEM = "SYSTÉM",
      .settings_DEBUG = "LADĚNÍ",
      .settings_EDIT_TIPS = "HROTY",
      .settings_CALIBRATION = "KALIBRACE",
      .settings_EXIT = "EXIT",
#ifdef ENABLE_ADDONS
      .settings_ADDONS = "DOPLŇKY",
#endif

#ifdef ENABLE_ADDON_FUME_EXTRACTOR
      .FUME_EXTRACTOR_Title         = "ODTAH SPLODIN",
      .FUME_EXTRACTOR_Mode          = "Mód",
      .FUME_EXTRACTOR_Modes         = { "VYPNUTO", "AUTO", "ZAPNUTO" },
      .FUME_EXTRACTOR_AfterRun      = "Při ÚTLUMu",
      .FUME_EXTRACTOR_AfterRunUnit  = "s",
#endif

#ifdef ENABLE_ADDON_SWITCH_OFF_REMINDER
      .SWITCH_OFF_REMINDER_Title               = "HLÁŠKA VYPNUTÍ",
      .SWITCH_OFF_REMINDER_EnableDisableOption = "Připomínka",
      .SWITCH_OFF_REMINDER_InactivityDelay     = "Odklad",
      .SWITCH_OFF_REMINDER_ReminderPeriod     = "Interval",
      .SWITCH_OFF_REMINDER_TimeUnit            = "min",
      .SWITCH_OFF_REMINDER_BeepType            = "Tón",
      .SWITCH_OFF_REMINDER_BeepTypes           = {"KRÁTKÝ" ,"STŘEDNÍ" ,"DLOUHÝ"},
#endif

      .IRON_Profile = "Profil",
      .IRON_Max_Temp = "t max",
      .IRON_Min_Temp = "t min",
      .IRON_Standby = "ÚTLUM za",
      .IRON_Sleep = "SPÁNEK za",
      .IRON_Boost = "Čas TURBO",
      .IRON_Boost_Add = " Zvýšení o",
      .IRON_Cold_Boost = "TURBO mód",
      .IRON_ColdBoost_Threshold = " Při t >",
      .IRON_ColdBoost_Timeout = " Po dobu",
      .IRON_Wake_Mode = "Reakce na",
      .IRON_Shake_Filtering = " Filtr",
      .IRON_Stand_Mode = " Ve stojánku",
      .IRON_smartActiveEnable = "Detekce pájení",
      .IRON_smartActiveLoad = " Citlivost",
      .IRON_Power = "Výkon",
      .IRON_Heater = "Tělísko",
      .IRON_ADC_Time = "ADC čas",
      .IRON_PWM_mul = "PWM násobič",
      .IRON_No_Iron = "Chyba hrotu",
      .IRON_Error_Timeout = "Čas obnovy",
      .IRON_Error_Resume_Mode = " Obnova",
      .IRON_FILTER_MENU = "MENU FILTRU",
      .IRON_NTC_MENU = "MENU NTC",

      .FILTER_Filter = "Filtr",
      .FILTER__Threshold = " Práh zobr.",
      .FILTER__Count_limit = " Limit počtu",
      .FILTER__Step_down = " Krok dolů",
      .FILTER__Min = " Minimum",
      .FILTER_Reset_limit = "Reset limitu",

      .SYSTEM_Boot = "Po start",
      .SYSTEM_Button_Wake = "Tlačítko",
      .SYSTEM_Shake_Wake = "Pohyb",
      .SYSTEM_Encoder = "Enkodér",
      .SYSTEM_Buzzer = "Tón",
      .SYSTEM_Temperature = "Teplota",
      .SYSTEM__Step = " Krok",
      .SYSTEM__Big_Step = " Rychlý krok",
      .SYSTEM_Active_Detection = "Detekce hrotu",
      .SYSTEM_LVP = "Min. napětí",
      .SYSTEM_Gui_Time = "Refresh",
      .SYSTEM_Battery = "Baterie",
      .SYSTEM_DEBUG = "LADĚNÍ",
      .SYSTEM_RESET_MENU = "MENU MAZÁNÍ",

      .SYSTEM_DISPLAY_MENU = "DISPLEJ",
#ifndef ST756
      .DISPLAY_ContrastOrBrightness = "Jas",
#else
      .DISPLAY_ContrastOrBrightness = "Kontrast",
#endif
      .DISPLAY_StartColumn = "X",
      .DISPLAY_StartLine = "Y",
      .DISPLAY_Xflip = "X otočení",
      .DISPLAY_Yflip = "Y otočení",
      .DISPLAY_Ratio = "Poměr",
      .DISPLAY_Dim = "Stmívač",
      .DISPLAY_Dim_inSleep = " Mód SPÁNEK",
      .DISPLAY_Advanced = "POKROČILÝ",

      .NTC_Enable_NTC = "Povolit NTC",
      .NTC_Pull = "Rezistor k",
      .NTC__Res = " Hodnota",
      .NTC__Beta = " Beta",
      .NTC_NTC_Detect = "NTC detekce",
      .NTC__High = " +",
      .NTC__Low = " -",

      .RESET_Reset_Settings = "Mazání nastavení",
      .RESET_Reset_Profile = "Mazání profilu",
      .RESET_Reset_Profiles = "Mazání profilů",
      .RESET_Reset_All = "Mazání všeho",
      .RESET_Reset_msg_settings_1 = "SMAZAT SYSTÉMOVÁ",
      .RESET_Reset_msg_settings_2 = "NASTAVENÍ?",
      .RESET_Reset_msg_profile_1 = "SMAZAT STÁVAJÍCÍ",
      .RESET_Reset_msg_profile_2 = "PROFIL?",
      .RESET_Reset_msg_profiles_1 = "SMAZAT VŠECHNY",
      .RESET_Reset_msg_profiles_2 = "PROFILY?",
      .RESET_Reset_msg_all_1 = "OPRAVDU PROVÉST",
      .RESET_Reset_msg_all_2 = "OBNOVU SYSTÉMU?",

      .TIP_SETTINGS_Name = "Název",
      .TIP_SETTINGS_PID_kp = "PID Kp",
      .TIP_SETTINGS_PID_ki = "PID Ki",
      .TIP_SETTINGS_PID_kd = "PID Kd",
      .TIP_SETTINGS_PID_Imax = "PID Imax",
      .TIP_SETTINGS_PID_Imin = "PID Imin",
      .TIP_SETTINGS_COPY = "KOPÍROVAT",
      .TIP_SETTINGS_DELETE = "SMAZAT",

      .CAL_ZeroSet = "Nast. nuly ",       // Must be 11 chars long
      .CAL_Sampling = "Vzorkování ",      // Must be 11 chars long
      .CAL_Captured = "Změřeno    ",      // Must be 11 chars long
      .CAL_Step = "KROK:",
      .CAL_Wait = "ČEKEJ ...",
      .CAL_Measured = "ZMĚŘENO:",
      .CAL_Success = "ÚSPĚCH!",
      .CAL_Failed = "CHYBA!",
      .CAL_DELTA_HIGH_1 = "PŘÍLIŠ VELKÝ ROZDÍL!",
      .CAL_DELTA_HIGH_2 = "Nastavte ručně",
      .CAL_DELTA_HIGH_3 = "a zkuste znovu",
      .CAL_Error = "ZJIŠTĚNA CHYBA!",
      .CAL_Aborting = "Rušení ...",

      ._Language = "Jazyk",
      .__Temp = " Teplota",
      .__Delay = " Odklad",
      .__Time = " Čas",
      ._Cal_250 = "Kal. 250\260C",
      ._Cal_400 = "Kal. 400\260C",
	  ._Cal_Diff = "t2 dif.",
      ._BACK = "EXIT",
      ._SAVE = "ULOŽIT",
      ._CANCEL = "ZRUŠIT",
      ._STOP = "STOP",
      ._RESET = "RESET",
      ._START = "START",
      ._SETTINGS = "NASTAVENÍ",
      ._ADD_NEW = "PŘIDAT NOVÝ",

      .ERROR_RUNAWAY = "TEPLOTA ",
      .ERROR_EXCEEDED = "PŘESAHUJE",
      .ERROR_UNKNOWN = "NEZNÁMÁ CHYBA",
      .ERROR_SYSTEM_HALTED = "ZASTAVENÍ SYSTÉMU",
      .ERROR_BTN_RESET = "Tlačítko:RESET",

      .OffOn =       { "VYP", "ZAP" },
      .DownUp =      { "GND", "Vdd" },
      .WakeModes =   { "NEAKTIVNÍ", "ÚTLUM", "SPÁNEK", "VŽDY" },
      .wakeMode =    { "POHYB", "STOJÁNEK" },
      .encMode =     { "REV.", "NORM." },
      .InitMode =    { "SPÁNEK", "ÚTLUM", "ZAP." },
      .dimMode =     { "NE", "SPÁNEK", "VŽDY" },
      .errMode =     { "SPÁNEK", "ZAP.", "POSLEDNÍ" },
    },
};


char * const tempUnit[2]              = { "\260C", "\260F" };
char * const profileStr[NUM_PROFILES] = { "TWZRS", "PROF1", "PROF2" };
char * const Langs[LANGUAGE_COUNT]    = {
                                            [lang_english]  = "EN",
                                            [lang_russian]  = "RU",
                                            [lang_swedish]  = "SWE",
                                            [lang_german]   = "GER",
                                            [lang_turkish]  = "TR",
                                            [lang_schinese] = "简中",
                                            [lang_tchinese] = "繁中",
                                            [lang_bulgarian] = "BG",
                                            [lang_czech] = "CZ",
                                        };
