# Operating Instructions<br>

## Initial Startup<br>
When an unconfigured (new or fully reset) controller starts, an initial setup screen will be shown to setup the system language and the tip profile.<br>

Currently, these are the available languages:
- **Bulgarian**<br>
- **Chinese**<br>
- **English**<br>
- **German**<br>
- **Russian**<br>
- **Swedish**<br>
- **Turkish**<br>

You can select between the following profiles:
- **Hakko T12** (T15 Series in North America & EU) This is the handle normally used with these controllers.<br>
- **JBC C210**<br>
- **JBC C245**<br>

---

## Basic Controls<br>
Changes are made using the rotary encoder and its push button.<br>
The power supply voltage is shown upper left.<br>
The internal temperature is on the upper right.<br>
The current selected tip appears on the bottom left.<br>
A bar graph of relative power going to the tip is shown on the bottom.<br>
While in normal operation, shake sensor activity will be shown briefly in the bottom center.<br>
In normal mode, the setpoint is shown in the upper center, otherwise, the current mode will be shown (sleep, standby, boost).<br>
To operate the menus, rotate to scroll to the desired selection, quick press to select it, rotate to change.<br>
Quick press again to stop editing the setting.<br>
While editing the widget, moderate rotation speed will make fine adjustement, a fast rotation will do coarse adjustment (big steps).<br><br>
For some actions you might be instructed to issue a Drag rotation.<br>
This means clicking the button (Helding down) and rotating at the same time.<br>
The time between pressing and rotating must be short, i.e. don't keep the button down for two seconds before rotating, doesn't need to be blazing fast either, just done in a natural way.<br>
After a drag-rotation was detected, release the button and use the encoder normally (Don't keep pressing to move, etc).<br>

---

## Theory of Operation<br>
Before covering the settings, it is useful to understand how it works.<br>
Tip temperature is measured by using an ADC (Analog-Digital Converter) to measure the voltage output by a thermocouple in the tip.<br>
The voltage generated by the sensor is proportional to the difference between tip temperature and the "cold side" (Measured by the internal sensor).
The controller uses PWM (Pulse Width Modulation) to control the tip temperature.<br>
PWM basically varies the amount of time that the tip is powered.<br>
By default, PWM uses a 200 ms (5 times per second) period.<br>
If the tip is too hot, the controller will turn on power to the tip little or not at all during each cycle.<br>
If the tip is too cold, it will turn the power on for more of the period.<br>
The time the tip is powered on during each period is called the duty cycle.<br> 
<pre>
|<------ PWM PERIOD ------>|
| POWER |____ no power ____|
</pre>
The PID (Proportional, Integral, Derivative) algorithm determines the PWM duty cycle based on the difference between desired and measured tip temperatures.<br>

---

## Main screen<br>
  - **Temperature display modes**<br>
  Issue a counter-clockwise drag-rotation to switch between numeric and graph display.<br>
  The graph update rate is the same as the ADC reading frequency.<br>
  The numerical display uses a noise supression filter to show smooth values. Once the setpoint was reached, variations of +-5ºC will be ignored (Can be adjusted).<br>    
  The plot graph always uses real time readings.<br>
  
  - **Temperature setpoint adjustment**<br>
  Rotate the encoder, the setpoint will be shown, continue rotating to adjust it.<br>
  After 1 second of inactivity it will return to normal mode.<br>
- **Sleep/Standby modes**<br>
  You can manually enter lower power modes by clicking in the main screen.<br>
  The sequence would be [run/boost mode]->[standby mode]->[sleep mode].<br>
  If button wake is enabled, encoder activity will resume normal mode, otherwise only the display brightness will be restored.<br>
  Wake-up sources are the enconder (If enabled) or handle wake input sensor (If shake wake is enabled or in stand mode).<br>
  The encoder only resumes normal mode when adjusting the setpoint or clicking in the temperature screen (Not when selecting tips or navigating in the menu)<br>
- **Boost mode**<br>
  Rotate the encoder to show up the setpoint adjustment and click within 1 second to trigger boost mode.<br>
  If more than 1 second has passed, boost mode won't be triggered, this is to prevent accidental triggering when adjusting the temperature.<br>
  While boost mode is enabled, clicking or rotating the encoder will return to normal mode.<br>
- **Tip selection**<br>
  Issue a clockwise drag-rotation to show the tip selection. The tip name label will be highlighted.<br>
  Rotate to change the selected tip, click or wait 2 seconds to select and return to normal mode. Long-click to enter the tip settings.<br>
  When inserting a new tip, this setting will be enabled automatically for 5 seconds.<br>
  To avoid unintended behaviour, at least 3 seconds must pass between tip changes, lower than that will be considered noise or momentary connection break.<br>
- **Profile selection**<br>
  Issue a drag-rotation while in Tip selection mode to show the profile selection.<br>
  Rotate to change the selected profile (T12, C210, C245), click or wait 2 seconds to select and return to normal mode.
- **System menu**<br>
  A long click will enter the system menu (Except while in tip selection/setpoint adjustment).<br>

---

## System menu<br>
Most screens will return to main screen after 15 seconds of inactivity.<br>
Long-clicking will have the same effect.<br>
In most menus, issue an anti-clockwise drag-rotation to quickly return to previous screen.<br>

### IRON
Iron settings control the operation of the handle/tips. The settings here apply only for the currently selected profile. In other words, each profile has its own dataset.<br>
  - **Profile**<br>
You can also change the current profile here. The display will instantly reload the new profile settings.<br>
  - **Max temperature**<br>
Upper adjustable temperature limit.<br>
  - **Min temperature**<br>
Lower adjustable temperature limit.<br>
  - **Dflt. temperature**<br>
Boost mode run time before resuming normal mode.<br>
  - **Boost temperature**<br>
Temperature offset applied in boost mode. It's added to the current temperature and limited to system maximum temperature.<br>
  - **Wake mode**<br>
How to detect activity. SHAKE or STAND.<br>
SHAKE uses a motion sensor present in T12 handles, shake or hold the handle tip up to wake.<br>
STAND uses the same input, but disconnected from the handle. Must be shorted to gnd when the handle is in the stand.<br>
(Stand mode operation operation: Shorted to gnd = sleep/standby, open = run ).<br>
  - **Filter**<br>
Filters the wake input to make it less sensitive, so it doesn't get waken by any little noise or slight  movement.<br>
This option is disabled in stand mode.<br>
  - **Stand mode**<br>
Sets the mode that will be applied when the handle is put in the stand (__STANDBY__ or __SLEEP__).<br>
This option is disabled in shake input mode.<br>
  - **(Stand)  Delay**<br>
Configures the Stand delay, so the station doesn't enter low power mode inmediately when placing the handle.<br>
This option is only enabled in stand input mode, default setting is 0 (Sleep inmediately).<br>
  - **Standby time**<br>
If there is no soldering activity for this period, the controller will reduce the temperature to extend the tip life and reduce power waste.<br>
Setting this option to 0 will disable standby mode, the station will switch to sleep state.<br>
  - **Standby temperature**<br>
Temperature applied in standby mode.<br>
  - **Sleep time**<br>
If there is no soldering activity for this period, the controller will "sleep" and stop providing power to the tip.<br>
This helps increase tip lifetime reduce power waste. Activity (e.g. shaking the handle for a T12) will wake it up and heating will resume.<br>
This timer cannot be disabled.<br>
  - **Boost time**<br>
Boost mode run time before resuming normal mode.<br>
  - **Boost increase**<br>
Temperature increase applied in boost mode. It's added to the current temperature and limited to system maximum temperature.<br>
  - **Cold boost**<br>
Activated when inserting a tip. Meant to speed up heating on cheap iron tips, as the heat needs more time to spread over the metal body.<br>
Genuine T12 / JBC tips shouldn't need this!<br>
  - **Cold boost threshold**<br>
If [target temperature - current temperature] surpasses this threshold, boost is automatically triggered.<br>
This option is only enabled when Cold Boost is active.<br>
  - **Cold boost timeout**<br>
How much time the automatic boost will be applied.<br>
This option is only enabled when Cold Boost is active.<br>
  - **Wake mode**<br>
WAKE input working mode (__SHAKE__ or __STAND__).<br>
SHAKE uses a motion sensor present in T12 handles, the station will keep working while motion is detected.<br>
STAND uses the same input, but disconnected from the handle. Must be shorted to gnd when the handle is in the stand.<br>
(Stand mode operation operation: Shorted to gnd = sleep/standby, open = run ).<br>
  - **Wake Filter**<br>
Filters the wake input to make it less sensitive, so it doesn't get waken by any little noise or slight movement.<br>
This option is disabled in stand wake mode.<br>
  - **Stand mode**<br>
Sets the mode that will be applied when the handle is put in the stand (__STANDBY__ or __SLEEP__).<br>
This option is disabled in shake wake mode.<br>
  - **Smart Active**<br>
Enables or disables Smart Active mode. This functionality tries to detect the load on the tip and resets the timeout automatically.<br> 
Works only in active modes, Run and Boost.<br>
Needs stable readings to work properly, might not work as intended with noisy controllers or tips (Specially new tips!).<br>
When working mode starts, the functionality will be delayed for 10 seconds to give the tip some time to heat up.<br>
Detection works by keeping track of the temperature drops of the last 6 seconds, trying to detect small changes.<br> 
On detection, the shake icon blinks to provide some feeback.<br>
  - **Smart Active Load**<br>
Adjust the Smart sensitivity. The lower the value, the higher the sensitivity.<br>
The sensitivity will be affected by the tip type, the PID response, the working temperature and the soldering target.<br>
Lower the value until it triggers randomly without soldering anything, then increase slightly until you don't get any false triggering.<br>
If your soldering station is really well tuned, you might be able to lower it to 3...4.<br>
A wrong value here might keep the station working forever, so be careful!<br>
This option is only enabled when Smart is active.<br>
  - **Power**<br>
The maximum power which will be delivered to the tip.<br>
The limit is done by adjusting the maximum PWM duty cycle based on the power supply voltage and the heater resistance.<br>
  - **Heater (resistance)**<br>
The resistance of the tip's heating element in ohms, used for the power limitation. There is normally no need to change this from the default.<br>
  - **ADC Time**<br>
Sets the ADC reading period. The controller disables the power and runs the ADC at this frequency. Default 200 ms.<br>
It also sets the base PWM frequency. The PWM multiplier uses this base.<br>
  - **(ADC) Delay**<br>
After turning off the power, a small delay is required to get a clean signal before the ADC reads the temperature.
If the delay is too low, it will read switching noise and be very unstable.<br>
If you get random spikes in the temperature, try increasing this value. 20mS is usually more than enough.<br>
There are other factors that could cause unstability, like poor circuit design, power supply noise or bad quality parts.<br>
Default 20 ms.<br>
<pre>
    |<-------------- ADC TIME --------------->|
     ___     ___     ___|<-  DELAY  ->[ READ ] ___     ___    
PWM     |___|   |___|   |_____________________|   |___|   |___ 
</pre>
  - **PWM multiplier**<br>
Sets the PWM period, using the formula ADC Time/multiplier.<br>
Default: x1.<br>
  - **No iron**<br>
Sets the ADC reading threshold that detects when there's no iron present.<br>
When the iron is not inserted, usually the reading will be close to the maximum ADC range(4095).<br>
Values >4095 will disable "no iron" detection.<br>
Default 4000, max 4096.<br>
  - **Error timeout**<br>
Time to wait after an error has gone before resuming normal operation.<br>
This is also useful to provide additional time when inserting a new tip, so the power is delayed.<br>
  - **Error resume**<br>
Set the mode the station will be set after errors are no longer present: Sleep, Run, Last mode.<br>
  - **FILTER SETTINGS**<br>
Here you can adjust the different the filtering settings.<br>
The firmware uses Exponential Moving Average (EMA) to filter the noise from the ADC readings.<br>
Keep in mind that wrong settings will cause a lot of trouble, PID is heavily affected by the signal noise.<br>
    - **Filter**<br>
Coefficient normally applied. The filtering will be heavier as the value increases.<br>
     - **Threshold**<br>
Defines the limit in the amplitude of the changes from the last average. Exceeding this will increase the threshold counter, while resetting it if under the limit.<br>
     - **Count limit**<br>
If the threshold detection counter becomes greater than this limit, the coefficient will start to be throttled down to improve response.<br>  
     - **Step down**<br>
This is the value that will be subtracted to the coefficient each time after the threshold counter was exceeded.<br>
Every new reading exceeding the threshold will subtract this value in an acumulative way, until reaching the min value if the condition doesn't stabilize.<br>
     - **Min**<br>
This is the minimum filtering coefficient that the system will be allowed to use.
    - **Reset limit**<br>
Exceeding this limit will instantly reset the filter and use the current reading.<br>
This is used for huge differences, usually when the tip is removed or plugged in, to allow instant response from the system.<br>
  - **NTC MENU**<br>
Adjust NTC settings:<br>
    - **Pull mode**<br>
Adjust as your circuit: Pull up or pull down.<br>
    - **Pull resistance**<br>
    - **NTC Detect** : Enables or disables automatic switching between 2 NTC values (typically 10K and 100K).<br>
        
        OFF: Fixed NTC values:<br>
        - **NTC resistance**<br>
          - **NTC beta coefficient**<br>
          
        ON: Two NTC values:<br>
          - **Higher NTC value**<br>
          - **Higher NTC Beta**<br>
          - **Lower NTC value**<br>
          - **Lower NTC Beta**<br>
    - **Back**<br>
Return to iron menu.<br>
  - **Back**<br>
Return to system menu.<br>

---

### SYSTEM
General global settings for the controller.<br>
  - **Language**<br>
Sets the display language.<br>
  - **Boot**<br>
Operation mode when powered on (__RUN__, __STANDBY__ or __SLEEP__).<br>
This option is disabled in stand mode.<br>
  - **Button Wake**<br>
Selects what modes can be waken with encoder activity.<br>
[None] [Standby only] [Sleep only] [All]<br>
This option is disabled when Wake mode is set to Stand.<br>
  - **Shake Wake**<br>
Selects what modes can be waken with shake activity.<br>
[None] [Standby only] [Sleep only] [All]<br>
This option is disabled when Wake mode is set to Stand.<br>
  - **Encoder**<br>
Invert the encoder direction.<br>
  - **Buzzer**<br>
    Buzz/beep when notable conditions occur.<br>
       - Changing operating mode (sleep, standby, run, boost)<br>
       - Temperature reached after the setpoint was changed<br>
       - Alarm when no iron is detected or system error happens<br>
  - **Temperature unit**<br>
Sets the system temperature in Celsius or Fahrenheit.<br>
  - **Step**<br>
Step for adjusting tip temperature in the main screen.<br>
 - **Big Step**<br>
Big step for adjusting tip temperature in the main screen, when the encoder is rotated fast.<br>
 - **Threshold for widget de-noiser**<br>
The screen widget will ignore the real temperature and show the setpoint if the deviation is lower than this value.<br>
Ex. Using value of 5, the screen will ignore changes of ±5°(C/F). Useful if your controller readings are noisy.<br>
A value of 0 will disable the threshold, always showing the real remperature.<br>
This is not applied to the plot graph.<br>
  - **LVP**<br>
Adjust Low voltage protection.<br>
  - **Active detection**<br>
Use iron active detection by leaving the PWM slightly on all the time. If your amp has a pullup resistor it can be disabled.<br>
  - **GUI Time**<br>
To offer maximum responsiveness, the screen is updated as fastest as possible when the cpu is idling.<br>
It depends on the MCU used and display interface, it can reach more than 100 fps in DMA SPI mode.<br>
If the display readings were updated at the same speed, it would be impossible to read anything.<br>
This setting defines the time in mS where the main screen readings are updated (voltage, temperatures).<br>
The effective update rate will be limited by the ADC read frequency.<br> 
Use a higher setting for less "flickery" display (more steady values).<br>
  - **Battery**<br>
If your board has the RTC batery installed, enabling this option will store temperature, tip and profile in the RTC SRAM, reducing flash wear.<br>
  - **DEBUG**<br>
Enable debugging menu.<br>
  - **RESET MENU**<br>
Reset various configuration sections:<br>
    - **Settings**<br>
Reset Settings menu items to default.<br>
    - **Profile**<br>
Reset the current profile (iron/tips) to default.<br>
    - **Profiles**<br>
Reset all profiles to default.<br>
    - **All**<br>
Reset everything.<br>
  - **DISPLAY**<br>
Adjust the display settings:<br>
    - **Contrast**<br>
Screen Contrast/brightness.<br>
    - **X (Offset)**<br>
This adjustment will modify the horizontal position.<br>
Some screens have different internal layout, shifting the picture position, this will fix it.<br>
    - **Y (Offset)**<br>
This adjustment will modify the vertical position.<br>
As the previous setting, some screens have different internal layout, shifting the picture position.<br>
    - **X flip**<br>
Toggles screen horizontal flip.<br>
    - **Y flip**<br>
Toggles screen vertical flip.<br>
    - **Dimmer**<br>
Fades the display after a timeout.
        - OFF: Never dim the screen.<br>
        - SLP: Dim only in low power modes (Standby, Sleep, Error).<br>
        - ALL: Dim also in run mode.<br>
    - **Dimmer Delay**<br>
Sets the dimmer timeout. This option is disabled when the dimmer is set to OFF.<br>
    - **Dimmer, in sleep mode**<br>
Allows to turn off the screen in sleep or error modes. This option is disabled when the dimmer is set to OFF.<br>
For safety reasons,the screen will only turn off when the iron temperature is below 100°C.<br>
        - OFF: In sleep mode, the screen turns off after dimming.<br>
        - ON: The screen stays on at low brightness.<br>
    - **ADVANCED**<br>
Additional low-level display tweaking.<br>
Refer to the SH1106 / SSD1306 / SSD1309 datasheet for more information about these commands.<br>
        - CLK:  Cmd 0xD5 "Display Clock Divide Ratio/Oscillator Frequency".<br>
        - PRE:  Cmd 0xD9 "Set Pre-charge Period".<br>
        - VCOM: Cmd 0xDB "Set VCOMH Deselect Level".<br>
        - RESET: Load defaults (You still need to click SAVE to store changes).<br>
        - SAVE: Save changes.<br>
        - CANCEL: Discard changes.<br>
    - **Back**<br>
Return to settings menu.<br>
  - **SW:**<br>
Displays the current software version. Actually, it's the build date.<br>
  - **HW:**<br>
Displays the controller model.<br>
  - **Back**<br>
Return to system menu.<br>

---

### EDIT TIPS
Different tips may have different characteristics. Tips may be added or edited here.<br>
Select a tip to enter tip settings edit screen, or select Add New to create a new tip.<br>
The new tip will be created by copying the PID/calibration settings from the first in the system.<br>
Each profile (T12, C245, C210) can store up to 85 tips.<br>
You can also set the working tip by long-clicking over it.<br>
Tips will be automatically sorted by name after adding/removing/modifying.<br>

### EDIT TIP SETTINGS
This menu allows Tip name editing, copying, deleting, PID tuning and adjustment of stored tip calibration values.<br>
PID tuning is an advanced topic, _**incorrect settings here can result in instability and erratic response**_.<br>
Kp, Ki, Kd, Imax, Imin are the coefficients which control the PID's behavior.<br>
Calibration values are not meant for doing manual calibrations, only to restore a previous calibration result.<br>
Use calibration for optimal results.<br>
  - **TIP NAME**<br>
Shows the tip name, click on it to edit the name.<br>
Keep clicking to switch to the next characters, it will exit editing mode when clicking in the last character.<br>
Additionally, you can navigate to any position using drag-rotation method.<br>
  - **PID Kp**<br> 
The proportional term, changes the PWM duty cycle based on how far the measured temperature is from the desired temperature.<br>
  - **PID Ki**<br>
The integral term, changes the duty cycle based on how long the temperatures have been different.<br>
  - **PID Kd**<br>
PID differential term, changes the duty cycle based on how fast the measured temperature has changed.<br>
  - **PID Imax**<br>
The integral accumulator higher limit.<br>
  - **PID Imin**<br>
The integral accumulator lower limit. As the system can't do anything to actively cool down the tip, it's usually set to 0.<br>
  - **Cal250**<br>
The stored value for 250ºC calibration.<br>
  - **Cal400**<br>
The stored value for 400ºC calibration.<br>
  - **SAVE**<br>
Save the tip settings.<br>
This option will be disabled if the tip name is empty or already exists.<br>
If this is a new tip then it is automatically selected as the active one.<br>
  - **RESET**<br>
Resets values to default, keeping existing name.<br>
You still need to save for changes to be applied. 
  - **ADD NEW**<br>
Copy this tip into a new slot, loading the default name.<br>
This option will be disabled if already copying the tip or when there are no free slots left.<br>
  - **COPY**<br>
Copy this tip into a new slot, keeping the name.<br>
This option will be disabled if already copying the tip or when there are no free slots left.<br>
  - **DELETE**<br>
Delete the current tip.<br>
This option will be disabled if this is a new tip or when there's only one tip in the system.<br>
  - **SAVE**<br>
Save changes. This option will be disabled if other tip in the system has the same name.<br>
  - **CANCEL**<br>
Discard any changes and return.<br>

---

### CALIBRATION
When entering this menu, the power is removed from the tip. For best calibration results, insert a cold tip now (Before entering any sub-menu).<br>
You can start your station without tip to prevent it from heating up, then enter CALIBRATION, insert the tip and calibrate it.<br>
Using a cold tip is only critical for the amplifier offset calibration (SETTINGS). If normal calibration works (START) or zero set is already adjusted, it's not required.<br>
START and SETTINGS menus will show warning message if the tip was removed or not detected and then return to main calibration menu.<br>
  - **START**<br>
Requires a tip thermometer (e.g. Hakko FG-100 or similar). Calibrates the current tip at temperatures of 250 and 400°C.<br>
Wait for tip temperature to settle (When the thermomether reading stops moving), it can take up to 20 seconds in some cases.<br>
Then enter temperature as measured by the thermometer for each step.<br>
If the entered temperature is more than 50ºC away from the target, the process will be aborted and you will have to adjust it manually.<br>
This values have nothing to do with the Tip Settings calibration values! These are for the tip, while this ones are only used for the calibration process.<br>
You can cancel the process at any time by clicking the STOP button.<br>
  - **SETTINGS**<br>
Here you can manually adjust the default calibration values, normally this needs to be done only once.<br> 
Cal 250 depends on Zero set, and Cal 400 depends on Cal 250, so if you're changing this, you must follow the correct order:<br>
Zero set (Sampling->Captured) -> Cal 250 -> Cal 400 -> Save<br>  
If by any means the 250°C calibration needs to go higher than 400°C value, increase 400°C value carefully and repeat 250°C calibration.<br>
For best accuracy, always calibrate 250°C if CAL_Zero value was changed, and always calibrate 400°C if 250°C value was changed.<br>
  
      - **Zero set**<br>
Calibrates the offset of the amplifier. You must have inserted a completely cold tip, or the calibration result will be wrong.<br>
This widgets has 3 states than change when clicking on it:<br>
        - Zero set: Shows the current value in the system (No changes).<br>
        - Sampling: Shows the ADC value in real time.<br>
        - Captured: Shows the captured value and applies it.<br>
To calibrate the zero offset, you must set this mode before moving to the next step.<br>
Zero set value is applied system-wide, not per-tip calibrated.<br>
If you already know your tip calibration values, you can adjust only this parameter and save, then restore the tip calibration values.<br>
    - **Cal 250ºC**<br>
    - **Cal 400ºC**<br>
Adjusts the value for 250/400°C. When editing this widget, the power is enabled and the value applied in real time.<br>
Move in small steps until the thermometer matches the target temperature
      - **SAVE**<br> 
Return to calibration menu saving changes.<br>
      - **CANCEL**<br>
Return to calibration menu discarding changes.<br>
  - **BACK**<br>
Return to system menu.<br>

---

### ADDONS/EXTRAS (if any addon is enabled during build)
This menu will provide the list of settings related to the addons/extras. Each of these has to be enabled in the board configuration. These settings applies to all profiles.

#### Fume extractor control
This addon provides automatic switch on/off for a connected fume extractor. To enable this addon define the *ENABLE_ADDON_FUME_EXTRACTOR* macro in the *board.h* file and in the MCU configuration create a digital output pin named "EXTRACTOR". A high level will be present if the extractor needs to operate.
  - **Mode**<br>
    - *OFF*  - The extractor is never switched on. <br>
    - *AUTO* - Enable the extractor if the iron is not in *sleep* or *standby*.<br>
    - *ON*   - The extractor is always switched on when the station is powered.<br>
  - **After Run** (only in *AUTO* mode)<br>
Keep the extractor on after leaving the *run* mode (entering *standby*) for the given amount of time.<br>
  - **BACK**<br>
Return to the addons screen.<br>

#### Switch off reminder
This addon provides a reminder to switch off the station (remove power) if its left in the *sleep* state for longer than the set amount of time. To enable this addon define the *ENABLE_ADDON_SWITCH_OFF_REMINDER* macro in the *board.h* file.
  - **Reminder**<br>
Enable/disable the reminder.<br>
  - **Delay**<br>
Start beeping if the station is in sleep mode longer than this amount of time.<br>
  - **Period**<br>
Repeat the reminder after this amount of minutes.<br>
  - **Beep len.**<br>
Length of the beep.<br>
  - **BACK**<br>
Return to the addons screen.<br>

---

### DEBUG (if enabled)
This is a menu to help debugging the controller, showing real-time readings.<br>
Clicking will switch between general and PID debug screens.<br>
Long-click will return to main screen.<br>

General debugging screen shows the following:
 - P, I, D (Current PID output)
 - Current temperature reading
 - Current setpoint (adjustable)
 - AVG (ADC value from iron tip temperature, filtered)
 - RAW (ADC value from iron tip temperature, unfiltered)
 - SET (Setpoint, converted to ADC value)
 - ERR (PID Error, difference between setpoint and average)
 - PWM (PWM duty value)
 - PWR (Power in %)

PID debugging screens shows 3 plots, representing:
 - P (Proportional)
 - I (Integral)
 - D (Derivative)

---

### ERROR REPORTING
A lot of effort was done to protect the tips from overheating.<br>
Any detected error will disable PWM and show a message on the display.<br>
To recover from an error, simply press the button and it will reboot.<br>
There are multiple error types:<br>
  - **Iron warning**<br>
For non critical errors, a warning will be shown: iron not detected, supply voltage too low, ambient temperature too high or too low, failsafe mode enabled.<br>
  - **Iron runaway**<br>
If by any means the iron temperature is higher than requested and the system is still powering the tip, it will trigger a timer depending on the temperature diference.<br>
The condition must dissapear within the specified time, otherwise it will trigger a critical runaway error, shutting down the power stage.<br>
This is very useful to protect the tip from wrong PID adjustments (Ex. excessive Integral values).<br>
  - **Internal function errors**<br>
If any internal function detects an undefined or not expected state, it will lock the station and show a message trying to show where the error happened (File, line).<br>
If this happens open a git hub ticket or a message in eevblog forum with the details.<br>
  - **Hardware exceptions**<br>
If a hardware exception happens, the station will lock up and display an error message about the exception.<br>
The CPU registers will be printed, the failure can be debugged out by searching the addresses in the listing file (.list) provided with the binaries.<br>
Fake stm32s cause lots of issues when writing data to flash, so additional information was added to hardfault screen:<br> 
    - Format is **`HARD FAULT, AA, BB`**, for example **`HARD FAULT, 9, 10`**.
    - **`AA`** is the Previous saving state.
    - **`BB`** is the Last saving state. If 0, then it didn't happen when saving.
    - Those numbers can be found in [settings.c](https://github.com/deividAlfa/stm32_soldering_iron_controller/blob/master/Core/Src/settings.c), searching **`DBG_SAVE(n)`**, where **`n`** is the number. 
  - **Data error detection**<br>
The data is stored as separate blocks: System settings, profile 1(T12), profile 2(C245) and profile 3(C210).<br>
Each one has it's own CRC checksum. When a block is read, the checksum is computed and compared.<br>
If a mismatch occurs, the block will be erased and resetted to defaults, trying to preserve the rest of the data.<br>
An error will be shown, detailing if the error detected was on the system settings data, or in any of the profiles.<br>
Also, the flash storage is checked carefully before and after writes, any issue will trigger a flash error message.<br>
  
 ### HARD RESET
If for any reason the station is unable to boot, you can't access the reset menu or you want to wipe everything up quickly, there's a hard reset method.<br>
Power the station off, push and hold the encoder button, and turn on the power.<br>
A message will appear in the screen. "Hold button to restore defaults".<br>
Keep pressing the button for another 5 seconds, until the next message appears, "Release button now".<br>
Release the button, the station will wipe everything and reboot.<br>

If you accidentally pushed the button, just release it before the 5 second timeout to resume the boot process.