/*
 *******************************************************************************
   USB-MIDI to Legacy Serial MIDI converter
   Copyright (C) 2012-2017 Yuuichi Akagawa

   Idea from LPK25 USB-MIDI to Serial MIDI converter
     by Collin Cunningham - makezine.com, narbotic.com

   This is sample program. Do not expect perfect behavior.
 *******************************************************************************
*/

#include <usbh_midi.h>
#include <usbhub.h>

// Satisfy the IDE, which needs to see the include statment in the ino too.
#ifdef dobogusinclude
#include <spi4teensy3.h>
#endif
#include <SPI.h>

#ifdef USBCON
#define _MIDI_SERIAL_PORT Serial1
#else
#define _MIDI_SERIAL_PORT Serial
#endif

#define LED1 6
#define LED2 7

#define LED_Time 200  // LED Time in ms

long LED_TIMER = 0;

//////////////////////////
// MIDI Pin assign
// 2 : GND
// 4 : +5V(Vcc) with 220ohm
// 5 : TX
//////////////////////////

USB Usb;
USBH_MIDI  Midi(&Usb);

void MIDI_poll();
void doDelay(uint32_t t1, uint32_t t2, uint32_t delayTime);

void LED_GREEN (void)
{
  digitalWrite(LED1, LOW);
  digitalWrite(LED2, HIGH);
}

void LED_RED (void)
{
  digitalWrite(LED1, HIGH);
  digitalWrite(LED2, LOW);
  LED_TIMER = millis() + LED_Time;
}

void LED_OFF (void)
{
  digitalWrite(LED1, LOW);
  digitalWrite(LED2, LOW);
  LED_TIMER = millis() + LED_Time;
}

void setup()
{
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  //LED_GREEN();

  _MIDI_SERIAL_PORT.begin(31250);
  //_MIDI_SERIAL_PORT.begin(38400); // Test
  
  if (Usb.Init() == -1) {
    while (1); //halt
  }//if (Usb.Init() == -1...
  delay( 200 );
}

void loop()
{
  Usb.Task();
  uint32_t t1 = (uint32_t)micros();
  if ( Usb.getUsbTaskState() == USB_STATE_RUNNING )
  {
    MIDI_poll();
  }
  if (millis() > LED_TIMER) LED_GREEN();
  //delay(1ms)
  doDelay(t1, (uint32_t)micros(), 1000);
}

// Poll USB MIDI Controler and send to serial MIDI
void MIDI_poll()
{
  uint8_t outBuf[ 3 ];
  uint8_t size;

  do {
    if ( (size = Midi.RecvData(outBuf)) > 0 ) {
      //MIDI Output
      LED_RED();
      _MIDI_SERIAL_PORT.write(outBuf, size);
    }
  } while (size > 0);
}

// Delay time (max 16383 us)
void doDelay(uint32_t t1, uint32_t t2, uint32_t delayTime)
{
  uint32_t t3;

  if ( t1 > t2 ) {
    t3 = (0xFFFFFFFF - t1 + t2);
  } else {
    t3 = t2 - t1;
  }

  if ( t3 < delayTime ) {
    delayMicroseconds(delayTime - t3);
  }
}
