/*  PS2Keyboard library, International Keyboard Layout Example
    http://www.pjrc.com/teensy/td_libs_PS2Keyboard.html

    keyboard.begin() accepts an optional 3rd parameter to
    configure the PS2 keyboard layout.  Uncomment the line for
    your keyboard.  If it doesn't exist, you can create it in
    PS2Keyboard.cpp and email paul@pjrc.com to have it included
    in future versions of this library.
*/

#include <PS2Kbd.h>

#define STROBE 12
#define CS 11
#define DATA 10
#define AX0 8
#define AX1 7
#define AX2 6
#define AY0 5
#define AY1 4
#define AY2 13

#define Row1 0 // X0
#define Row2 2 // X2
#define Row3 4 // X4
#define Row4 6 // X6
#define Row5 7 // X7

#define Column1 24 // Y3
#define Column2 16 // Y2
#define Column3 8 // Y1
#define Column4 0 // Y0
#define Column5 48 // Y6
#define Column6 32 // Y4
#define Column7 40 // Y5
#define Column8 56 // Y7

const int DataPin = 2;
const int IRQpin =  3;

PS2Kbd keyboard;

void SendMatrixSwitch(byte Address, bool KeyState) {
  if (Address & 1) digitalWrite(AX0, HIGH);
  else digitalWrite(AX0, LOW);
  if (Address & 2) digitalWrite(AX1, HIGH);
  else digitalWrite(AX1, LOW);
  if (Address & 4) digitalWrite(AX2, HIGH);
  else digitalWrite(AX2, LOW);
  if (Address & 8) digitalWrite(AY0, HIGH);
  else digitalWrite(AY0, LOW);
  if (Address & 16) digitalWrite(AY1, HIGH);
  else digitalWrite(AY1, LOW);
  if (Address & 32) digitalWrite(AY2, HIGH);
  else digitalWrite(AY2, LOW);
  digitalWrite(CS, LOW);
  if (KeyState) digitalWrite(DATA, HIGH);
  else digitalWrite(DATA, LOW);
  digitalWrite(STROBE, LOW);
  digitalWrite(STROBE, HIGH);
  digitalWrite(CS, HIGH);
  digitalWrite(DATA, LOW);
}


void setup() {
  digitalWrite(CS, HIGH);
  pinMode(CS, OUTPUT);
  digitalWrite(STROBE, HIGH);
  pinMode(STROBE, OUTPUT);
  pinMode(DATA, OUTPUT);
  pinMode(AX0, OUTPUT);
  pinMode(AX1, OUTPUT);
  pinMode(AX2, OUTPUT);
  pinMode(AY0, OUTPUT);
  pinMode(AY1, OUTPUT);
  pinMode(AY2, OUTPUT);
  keyboard.begin(DataPin, IRQpin);
  Serial.begin(9600);
  Serial.println("Keyboard Test:");
}

void loop() {
  bool KeyPressed;

  if (keyboard.available()) {
    byte c = keyboard.read();
    if (c > 127) KeyPressed = false;
    else KeyPressed = true;
    c &= 127;
    if (KeyPressed) Serial.print("Stisknuto > ");
    else Serial.print("Pusteno > ");
    Serial.println(c, HEX);
    switch (c) {
      case 0x15:    // Q
        SendMatrixSwitch(Column2 + Row1, KeyPressed);
        break;
      case 0x1D:    // W
        SendMatrixSwitch(Column2 + Row2, KeyPressed);
        break;
      case 0x24:    // E
        SendMatrixSwitch(Column2 + Row3, KeyPressed);
        break;
      case 0x2D:    // R
        SendMatrixSwitch(Column2 + Row4, KeyPressed);
        break;
      case 0x2C:    // T
        SendMatrixSwitch(Column2 + Row5, KeyPressed);
        break;
      case 0x35:    // Y
        SendMatrixSwitch(Column5 + Row5, KeyPressed);
        break;
      case 0x3C:    // U
        SendMatrixSwitch(Column5 + Row4, KeyPressed);
        break;
      case 0x43:    // I
        SendMatrixSwitch(Column5 + Row3, KeyPressed);
        break;
      case 0x44:    // O
        SendMatrixSwitch(Column5 + Row2, KeyPressed);
        break;
      case 0x4D:    // P
        SendMatrixSwitch(Column5 + Row1, KeyPressed);
        break;
      case 0x1C:    // A
        SendMatrixSwitch(Column3 + Row1, KeyPressed);
        break;
      case 0x1B:    // S
        SendMatrixSwitch(Column3 + Row2, KeyPressed);
        break;
      case 0x23:    // D
        SendMatrixSwitch(Column3 + Row3, KeyPressed);
        break;
      case 0x2B:    // F
        SendMatrixSwitch(Column3 + Row4, KeyPressed);
        break;
      case 0x34:    // G
        SendMatrixSwitch(Column3 + Row5, KeyPressed);
        break;
      case 0x33:    // H
        SendMatrixSwitch(Column7 + Row5, KeyPressed);
        break;
      case 0x3B:    // J
        SendMatrixSwitch(Column7 + Row4, KeyPressed);
        break;
      case 0x42:    // K
        SendMatrixSwitch(Column7 + Row3, KeyPressed);
        break;
      case 0x4B:    // L
        SendMatrixSwitch(Column7 + Row2, KeyPressed);
        break;
      case 0x1A:    // Z
        SendMatrixSwitch(Column6 + Row2, KeyPressed);
        break;
      case 0x22:    // X
        SendMatrixSwitch(Column6 + Row3, KeyPressed);
        break;
      case 0x21:    // C
        SendMatrixSwitch(Column6 + Row4, KeyPressed);
        break;
      case 0x2A:    // V
        SendMatrixSwitch(Column6 + Row5, KeyPressed);
        break;
      case 0x32:    // B
        SendMatrixSwitch(Column8 + Row5, KeyPressed);
        break;
      case 0x31:    // N
        SendMatrixSwitch(Column8 + Row4, KeyPressed);
        break;
      case 0x3A:    // M
        SendMatrixSwitch(Column8 + Row3, KeyPressed);
        break;
      case 0x5A:    // ENTER
        SendMatrixSwitch(Column7 + Row1, KeyPressed);
        break;
      case 0x12:    // LEFT SHIFT
        SendMatrixSwitch(Column8 + Row2, KeyPressed);
        break;
      case 0x59:    // RIGHT SHIFT
        SendMatrixSwitch(Column8 + Row2, KeyPressed);
        break;
      case 0x29:    // SPACE
        SendMatrixSwitch(Column8 + Row1, KeyPressed);
        break;
      case 0x58:    // CAPS LOCK
        SendMatrixSwitch(Column6 + Row1, KeyPressed);
        break;
      case 0x69:    // 1
        SendMatrixSwitch(Column1 + Row1, KeyPressed);
        break;
      case 0x72:    // 2
        SendMatrixSwitch(Column1 + Row2, KeyPressed);
        break;
      case 0x7A:    // 3
        SendMatrixSwitch(Column1 + Row3, KeyPressed);
        break;
      case 0x6B:    // 4
        SendMatrixSwitch(Column1 + Row4, KeyPressed);
        break;
      case 0x73:    // 5
        SendMatrixSwitch(Column1 + Row5, KeyPressed);
        break;
      case 0x74:    // 6
        SendMatrixSwitch(Column4 + Row5, KeyPressed);
        break;
      case 0x6C:    // 7
        SendMatrixSwitch(Column4 + Row4, KeyPressed);
        break;
      case 0x75:    // 8
        SendMatrixSwitch(Column4 + Row3, KeyPressed);
        break;
      case 0x7D:    // 9
        SendMatrixSwitch(Column4 + Row2, KeyPressed);
        break;
      case 0x70:    // 0
        SendMatrixSwitch(Column4 + Row1, KeyPressed);
        break;
      case 0x49:    // .
        if (KeyPressed) {
          SendMatrixSwitch(Column8 + Row2, KeyPressed); // SYMBOL SHIFT
          SendMatrixSwitch(Column8 + Row3, KeyPressed); // M
        }
        else {
          SendMatrixSwitch(Column8 + Row3, KeyPressed); // M
          SendMatrixSwitch(Column8 + Row2, KeyPressed); // SYMBOL SHIFT
        }
        break;
      case 0x41:    // .
        if (KeyPressed) {
          SendMatrixSwitch(Column8 + Row2, KeyPressed); // SYMBOL SHIFT
          SendMatrixSwitch(Column8 + Row4, KeyPressed); // N
        }
        else {
          SendMatrixSwitch(Column8 + Row4, KeyPressed); // N
          SendMatrixSwitch(Column8 + Row2, KeyPressed); // SYMBOL SHIFT
        }
        break;
      case 0x4C:    // ;
        if (KeyPressed) {
          SendMatrixSwitch(Column8 + Row2, KeyPressed); // SYMBOL SHIFT
          SendMatrixSwitch(Column5 + Row2, KeyPressed); // O
        }
        else {
          SendMatrixSwitch(Column5 + Row2, KeyPressed); // O
          SendMatrixSwitch(Column8 + Row2, KeyPressed); // SYMBOL SHIFT
        }
        break;
      case 0x66:    // BACKSPACE
        if (KeyPressed) {
          SendMatrixSwitch(Column6 + Row1, KeyPressed); // CAPS SHIFT
          SendMatrixSwitch(Column4 + Row1, KeyPressed); // 0
        }
        else {
          SendMatrixSwitch(Column4 + Row1, KeyPressed); // 0
          SendMatrixSwitch(Column6 + Row1, KeyPressed); // CAPS SHIFT
        }
        break;
      case PS2_DELETE:    // DELETE
        if (KeyPressed) {
          SendMatrixSwitch(Column6 + Row1, KeyPressed); // CAPS SHIFT
          SendMatrixSwitch(Column4 + Row1, KeyPressed); // 0
        }
        else {
          SendMatrixSwitch(Column4 + Row1, KeyPressed); // 0
          SendMatrixSwitch(Column6 + Row1, KeyPressed); // CAPS SHIFT
        }
        break;
    }
  }
}
